package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsGroupModel;
import com.yeejoin.amos.knowledgebase.face.service.DynamicsGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * <p>
 * 知识库系统动态选项配置的分组，用于区分不同功能的字段列表 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "dynamicsgroup")
@RequestMapping(value = "/v1/dynamicsgroup")
@Api(tags = "knowledgebase-统动态选项配置的分组")
public class DynamicsGroupResource {

    private final Logger logger = LogManager.getLogger(DynamicsGroupResource.class);



    @Autowired
    private  DynamicsGroupService dynamicsGroupService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "动态配置分组列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeDynamicsGroupModel>> queryByGroup() {
        return ResponseHelper.buildResponse(dynamicsGroupService.queryGroupList(RequestContext.getAppKey()));
    }
}
