package com.yeejoin.amos.latentdanger.core.util;

import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 字符串工具类
 * 
 * @author as-youjun
 *
 */
public class StringUtil {

	private static Pattern NOT_ZERO_AT_THE_END = Pattern.compile("[1-9](\\d*[1-9])?");

	private static Pattern numericPattern = Pattern.compile("-?[0-9]+\\.?[0-9]*");

	/**
	 * 判断对象是否为空
	 * 
	 * @param str
	 * @return
	 */
	public static boolean isNotEmpty(Object str) {
		boolean flag = true;
		if (str != null && !str.equals("")) {
			if (str.toString().length() > 0) {
				flag = true;
			}
		} else {
			flag = false;
		}
		return flag;
	}

	/***************************************************************************
	 * repeat - 通过源字符串重复生成N次组成新的字符串。
	 * 
	 * @param src
	 *            - 源字符串 例如: 空格(" "), 星号("*"), "浙江" 等等...
	 * @param num
	 *            - 重复生成次数
	 * @return 返回已生成的重复字符串
	 * @version 1.0 (2006.10.10) Wilson Lin
	 **************************************************************************/
	public static String repeat(String src, int num) {
		StringBuffer s = new StringBuffer();
		for (int i = 0; i < num; i++)
			s.append(src);
		return s.toString();
	}

	/**
	 * 判断是否数字表示
	 * 
	 * @param src
	 *            源字符串
	 * @return 是否数字的标志
	 */
	public static boolean isNumeric(String str) {
		// 该正则表达式可以匹配所有的数字 包括负数
		String bigStr;
		try {
			bigStr = new BigDecimal(str).toString();
		} catch (Exception e) {
			return false;// 异常 说明包含非数字。
		}

		Matcher isNum = numericPattern.matcher(bigStr); // matcher是全匹配
		if (!isNum.matches()) {
			return false;
		}
		return true;
	}

	public static int toInt(String s) {
		if (s != null && !"".equals(s.trim())) {
			try {
				return Integer.parseInt(s);
			} catch (Exception e) {
				return 0;
			}
		}
		return 0;
	}

	/**
	 * 截取前后都不是0的数字字符串
	 * 
	 * 12010102 => 12010102 12010100 => 120101 ab1201100b => 12011
	 * 
	 * @param str
	 * @return
	 */
	public static String delEndZero(String str) {
		Matcher mat = NOT_ZERO_AT_THE_END.matcher(str);
		boolean rs = mat.find();
		if (rs) {
			return mat.group(0);
		}

		return null;
	}

	/**
	 * 
	 * <pre>
	 * 移除字符串后面的0
	 * </pre>
	 *
	 * @param s
	 * @return
	 */
	public static String removeSufixZero(String s) {
		if (s == null) {
			return "";
		}
		while (s.endsWith("0")) {
			if (s.equals("0")) {
				s = "";
				break;
			}
			s = s.substring(0, s.length() - 1);
		}
		return s;
	}

	public static String transforCode(String code) {
		if (code.endsWith("0000000")) {
			code = code.substring(0, 1);
		} else if (code.endsWith("000000")) {
			code = code.substring(0, 2);
		} else if (code.endsWith("0000")) {
			code = code.substring(0, 4);
		} else if (code.endsWith("00")) {
			code = code.substring(0, 6);
		}
		return code;
	}

	/**
	 * 获取支队orgCode
	 * 
	 * @param orgCode
	 * @return
	 */
	public static String getDetachmentOrgCode(String orgCode) {
		Assert.notNull(orgCode, "组织结构orgCode不能为空！");
		String[] codes = orgCode.split("\\*");
		if (codes.length < 2) {
			throw new IllegalArgumentException("组织结构orgCode为总队，不能获取支队orgCode!");
		} else {
			return codes[0] + "*" + codes[1];
		}
	}
}
