package com.yeejoin.amos.maintenance.business.controller;


import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.service.intfc.IEquipmentHandlerService;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.business.util.Toke;
import com.yeejoin.amos.maintenance.dao.entity.InputItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.List;

/**
 * 任务
 *
 * @author wujunkai
 */
@RestController
@RequestMapping(value = "/api/equipmnetRule")
@Api(tags = "装备检查项")
public class EquipmentRuleController extends AbstractBaseController {

    @Autowired
    private IEquipmentHandlerService equipmentHandlerService;

    /**
     * 装备检查项
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "装备检查项", notes = "装备检查项")
    @RequestMapping(value = "/equipmnetInput", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse getPlanTaskList(
            @ApiParam(value = "检查项请求参数") @RequestBody() HashMap<String, Object> map) {
        Toke token = new Toke();
        token.setProduct(getProduct());
        token.setToke(getToken());
        token.setAppKey(getAppKey());
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getOrgCode(reginParams);
        map.put("orgCode", orgCode);
        equipmentHandlerService.fireEquipRuleMessagePush(map, token);
        return CommonResponseUtil.success();
    }

    /**
     * 装备检查项
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "装备检查项", notes = "装备检查项")
    @RequestMapping(value = "/getEquipmnetRules", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getEquipmnetRules(
            @ApiParam(value = "装备名称", required = true) @RequestParam() String equipmentName) {
        List<InputItem> list = equipmentHandlerService.getEquipmnetRulesByName(equipmentName);
        return CommonResponseUtil.success(list);
    }

}
