package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.CheckShot;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("checkShotDao")
public interface ICheckShotDao extends BaseDao<CheckShot, Long> {


	/**
	 * 检查项照片
	 * @param checkId
	 * @param checkInputId
	 * @return
	 */
	List<CheckShot> findAllByCheckIdAndCheckInputIdAndClassifyId(@Param("checkId") Long checkId, @Param("checkInputId") Long checkInputId, @Param("classifyId") Long classifyId);

	/**
	 * 检查项照片
	 *
	 * @param checkId
	 * @param checkInputId
	 * @return
	 */
	List<CheckShot> findAllByCheckIdAndCheckInputId(Long checkId, Long checkInputId);

	/**
	 * 根据check_input_id删除图片
	 */
//	@Modifying
//	@Transactional
//	@Query(value = "DELETE FROM p_check_shot WHERE check_input_id = ?1  ", nativeQuery = true)
//	void deleteByCheckInputId(Long checkInputId);
	void deleteByCheckInputId(Long checkInputId);
}
