package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 特种设备基本信息-其他信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_other_info")
@ApiModel(value="TmJgOtherInfo对象", description="特种设备基本信息-其他信息")
public class OtherInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备唯一标识码")

    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "保险机构")
    private String insuranceOrg;

    @ApiModelProperty(value = "保险到期日")
    private Date expiryDate;

    @ApiModelProperty(value = "物联网机构（非必填）")
    private String iotOrg;

    @ApiModelProperty(value = "物联网接入标志（非必填）")
    private String iotSign;

    @ApiModelProperty(value = "有无监控(有、无)")
    private String isMonitor;

    @ApiModelProperty(value = "96333识别码(七位电梯应急救援识别码)")
    private String code96333;
}
