package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.tdc.api.entity.SubmitRecord;
import com.yeejoin.amos.boot.module.tdc.api.mapper.SubmitRecordMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.SubmitRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Date;
import java.util.List;


/**
 * @author DELL
 */
@Service
public class SubmitRecordServiceImpl extends ServiceImpl<SubmitRecordMapper, SubmitRecord> implements SubmitRecordService {

    @Autowired
    SubmitRecordMapper submitRecordMapper;

    @Override
    public IPage<SubmitRecord> selectByOrgCode(int current, int size) {
        Page page = new Page(current,size);
        return submitRecordMapper.selectByOrgCode(page);
    }

    @Override
    public int saveSubmitRecord(SubmitRecord submitRecord) {
        return this.baseMapper.insert(submitRecord);
    }

    @Override
    public SubmitRecord updateById(Long sequenceNbr, String batchNo, int draft) {
        SubmitRecord submitRecord = this.getById(sequenceNbr);
        submitRecord.setBatchNo(batchNo);
        submitRecord.setDraft(draft);
        submitRecord.setSubmitTime(new Date());
        this.updateById(submitRecord);
        return submitRecord;
    }

    @Override
    public List<SubmitRecord> selectRecord() {
        LambdaQueryWrapper<SubmitRecord> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(SubmitRecord::getDraft,1);
        wrapper.orderByDesc(SubmitRecord::getSubmitTime);
        wrapper.last(" limit 20");
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public void saveFileId(Long id, Long fileId) {
        LambdaUpdateWrapper<SubmitRecord> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(SubmitRecord::getFileId, fileId);
        wrapper.set(SubmitRecord::getSequenceNbr, id);
        this.update(wrapper);
    }
}
