package com.yeejoin.amos.boot.module.ymt.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 气瓶充卸统计表
 *
 * @author system_generator
 * @date 2022-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_unload_data")
public class CylinderFillingUnloadData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 充装总量
     */
	@TableField("filling_sum")
    private Double fillingSum;

    /**
     * 卸液总量
     */
	@TableField("unload_sum")
    private Double unloadSum;

    /**
     * 充卸日期
     */
	@TableField("statis_date")
    private Date statisDate;

    /**
     * 充卸日期字符串
     */
	@TableField("statis_date_str")
    private String statisDateStr;

    /**
     * 区域编码
     */
	@TableField("region_code")
    private String regionCode;

    /**
     * 充卸年份
     */
	@TableField("statis_year")
    private String statisYear;

    /**
     * 更新时间
     */
	@TableField("update_time")
    private Date updateTime;

    /**
     * 充卸月份
     */
	@TableField("statis_month")
    private String statisMonth;

}
