package com.yeejoin.amos.boot.biz.common.service.impl;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.dao.mapper.DataDictionaryMapper;
import com.yeejoin.amos.boot.biz.common.dto.DataDictionaryDto;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.IDataDictionaryService;
import com.yeejoin.amos.boot.biz.common.utils.*;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import java.util.Collection;
import java.util.List;

/**
 * 数据字典 服务实现类
 *
 * @author tb
 * @date 2021-06-07
 */
@Service
@Getter
public class DataDictionaryServiceImpl extends BaseService<DataDictionaryDto, DataDictionary, DataDictionaryMapper> implements IDataDictionaryService {
    @Autowired
    RedisUtils redisUtils;

    @Value("${redis.cache.failure.time:10800}")
    private long time;
    @Autowired
    DataDictionaryMapper dataDictionaryMapper;

    @Override
    public Object getFireChemical(String type) throws Exception {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", type);
        queryWrapper.orderByAsc("sort_num");

        if (redisUtils.hasKey(RedisKey.DATA_DICTIONARY_CODE + type)) {
            Object obj = redisUtils.get(RedisKey.DATA_DICTIONARY_CODE + type);
            return obj;
        } else {
            Collection<DataDictionary> list = this.list(queryWrapper);
            // 数据字典生成树方法 原先通过getCode做主键  现修改为 getSequenceNbr 后期数据字典parent字段保存id 而不要保存code  by kongfm 2021-09-08
            // 数据字典还原 by kongfm 2021-09-09
            List<MenuFrom> menus = TreeParser.getTreexin(null, list, DataDictionary.class.getName(), "getCode", 0,
                    "getName", "getParent", null);
            MenuFrom Me = new MenuFrom("-1", "-1", "-1", "危化品库", "危化品库", "危化品库", "-1", null);
            Me.setIsLeaf(false);
            Me.setChildren(menus);
            redisUtils.set(RedisKey.DATA_DICTIONARY_CODE + type, JSON.toJSON(Me), time);
            return Me;
        }
    }

    @Override
    public Object gwmcDataDictionary(String type) throws Exception {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", type);
        queryWrapper.orderByAsc("sort_num");

        if (redisUtils.hasKey(RedisKey.DATA_DICTIONARY_CODE + type)) {
            Object obj = redisUtils.get(RedisKey.DATA_DICTIONARY_CODE + type);
            return obj;
        } else {
            Collection<DataDictionary> list = this.list(queryWrapper);
            // 数据字典生成树方法 原先通过getCode做主键  现修改为 getSequenceNbr 后期数据字典parent字段保存id 而不要保存code  by kongfm 2021-09-08
            // 数据字典还原 by kongfm 2021-09-09
            List<Menu> menus = TreeParser.getTree(null, list, DataDictionary.class.getName(), "getCode", 0, "getName"
                    , "getParent", null,null);
            redisUtils.set(RedisKey.DATA_DICTIONARY_CODE + type, JSON.toJSON(menus), time);
            return menus;
        }
    }

    public List<MenuFrom> getGWMCDataDictionary(String type) throws Exception {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", type);
        queryWrapper.orderByAsc("sort_num");

        Collection<DataDictionary> list = this.list(queryWrapper);
        // 数据字典生成树方法 原先通过getCode做主键  现修改为 getSequenceNbr 后期数据字典parent字段保存id 而不要保存code  by kongfm 2021-09-08
        // 数据字典还原 by kongfm 2021-09-09
        List<MenuFrom> menus = TreeParser.getTreexin(null, list, DataDictionary.class.getName(), "getCode", 0, "getName"
                , "getParent", null);
        return menus;

    }

    public DataDictionary getByCode(String code,String type)  {

        return dataDictionaryMapper.getByCode(code,type);

    }
    
    public List<DataDictionary> getDataDictionaryAndCount(){
    	List<DataDictionary> list=	dataDictionaryMapper.getDataDictionaryListAndCount();
    	for (DataDictionary data : list) {
    		Long id = data.getSequenceNbr();
    		int num = data.getCount();
    		for (DataDictionary dataDictionary : list) {
    			if(id.equals(dataDictionary.getParent())) {
    				num =num+dataDictionary.getCount();
    			}
    		}
    		data.setCount(num);
		}
		return list;
    }
    @Override
    public List<DataDictionary> getByType(String type)  {
    	LambdaQueryWrapper<DataDictionary> wrapper = new LambdaQueryWrapper<DataDictionary>();
    	wrapper.eq(DataDictionary::getIsDelete, false);
    	wrapper.eq(DataDictionary::getType, type);
        wrapper.orderByAsc(DataDictionary::getSortNum);
    return	this.baseMapper.selectList(wrapper);
    }
    
    public List<Menu> getFireTeamTypeTree(String bizOrgCode) throws Exception {
    	// Menu root = new Menu(null, "消防队伍类型", null, null,0);
    	List<DataDictionary> list=	dataDictionaryMapper.getFireTeamTypeTree(bizOrgCode);

    	List<Menu> menus = TreeParser.getTreeContainsCount(null, list, DataDictionary.class.getName(), "getCode", 0, "getName",
				"getParent", "getCount","getTreeCode");
    	// root.setChildren(menus);
        for (Menu m:menus
        ) {
            if( null != m.children) {
                List<Menu> children = m.getChildren();
                int count = m.num;
                for (Menu mm:children
                ) {
                    count = count + mm.num;
                }
                m.setNum(count);
            }
        }

		return Lists.newArrayList(menus);
    }
    public List<DataDictionary> getwaterResourceTypeTree(String bizOrgCode) throws Exception {
    	List<DataDictionary> list=	dataDictionaryMapper.getwaterResourceTypeTree(bizOrgCode);
//    	List<Menu> menus = TreeParser.getTree(null, list, DataDictionary.class.getName(), "getCode", 0, "getName",
//				"getParent", null);
//    	root.setChildren(menus);
		return list;
    }
    
    @Override
    public List<DataDictionary> getAllChildNodes(String type, Long parent) throws Exception {
    	LambdaQueryWrapper<DataDictionary> wrapper = new LambdaQueryWrapper<DataDictionary>();
    	wrapper.eq(DataDictionary::getIsDelete, false);
    	wrapper.eq(DataDictionary::getType, type);
    	if(parent!=null){
    	    wrapper.eq(DataDictionary::getParent, parent);
        }
    	return	this.baseMapper.selectList(wrapper);
    }

    @Override
    public List<DataDictionary> getChildList(String type, String group) {
        LambdaQueryWrapper<DataDictionary> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(DataDictionary::getType,type);
        wrapper.eq(DataDictionary::getTypeDesc,group);
        return this.list(wrapper);
    }

    @Override
    public List<DataDictionary> getByParent(String parent) {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("parent", parent);
        queryWrapper.orderByAsc("sort_num");
        return this.list(queryWrapper);
    }

    @Override
    public DataDictionary getByExtend(String groupId, String type) {
        LambdaQueryWrapper<DataDictionary> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(DataDictionary::getExtend, groupId);
        wrapper.likeRight(DataDictionary::getType, type);
        DataDictionary dataDictionary = dataDictionaryMapper.selectOne(wrapper);
        return ObjectUtils.isEmpty(dataDictionary) ? new DataDictionary() : dataDictionary;
    }

    @Override
    public IPage<DataDictionary> getDictByExtendsAndTypePage(String extend, String type, String name, Page<DataDictionary> page) {
        return dataDictionaryMapper.getDictByExtendsAndTypePage(page, type, extend,name);
    }
}
