package com.yeejoin.amos.api.openapi.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum CylinderInfoFieldEnum {
    creditCode(true, false),
    unitName(true, false),
    sequenceCode(true, true),
    cylinderVariety(true, false),
    cylinderVarietyName(true, false),
    factoryNum(true, false),
    fillingMedia(true, false),
    fillingMediaName(true, false),
    manufacturingUnit(true, false),
    manufacturingDate(true, false),
    manufacturingUnitCreditCode(true, false),
    valveManufacturUnit(true, false),
    nominalWorkPressure(true, false),
    volume(true, false),
    productQualified(true, false),
    proofQuality(true, false),
    supervisionInspec(true, false),
    typeExperiments(true, false),
    cylinderStatus(true, false),
    syncDate(true, false),
    syncState(true, false);

    private boolean isRequire;
    private boolean isUnique;

    public static List<String> getAllRequireKeys() {
        return Arrays.stream(values()).filter(e -> e.isRequire).map(Enum::name).collect(Collectors.toList());
    }

    public  static List<String> getAllUniqueKeys() {
        return Arrays.stream(values()).filter(e -> e.isUnique).map(Enum::name).collect(Collectors.toList());
    }
}
