package com.yeejoin.amos.boot.module.cylinder.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipmentCategoryEnum {

    /**
     * *行政区划分及对应初始监管码
     */

    XZQHDT("行政区划电梯", "XZQHDT", "行政区划电梯"),
    XZQH("行政区划", "XZQH", "行政区划"),
    BLW("补零位", "0", "补零位"),
    JGM("监管码初始码", "0000001", "监管码初始码"),
    XXCSM("西咸96333初始码", "85000", "31"),
    BJCSM("宝鸡96333初始码", "13000", "32"),
    XYCSM("咸阳96333初始码", "75000", "33"),
    TCCSM("铜川96333初始码", "05000", "34"),
    WNCSM("渭南96333初始码", "13000", "35"),
    YACSM("延安96333初始码", "11000", "36"),
    YUCSM("榆林96333初始码", "10000", "37"),
    HZCSM("汉中96333初始码", "09000", "38"),
    AKCSM("安康96333初始码", "11000", "39"),
    SLCSM("商洛96333初始码", "06000", "40"),
    YLCSM("杨凌96333初始码", "70000", "41"),
    HCCSM("韩城96333初始码", "08000", "42"),
    SMCSM("神木96333初始码", "06000", "43"),
    FGCSM("府谷96333初始码", "02000", "44"),
    YJL("已拒领", "6037", "已拒领"),
    YRL("已认领", "6035", "已认领"),
    DRL("待认领", "6036", "待认领"),
    CSZT("初始状态", "0", "初始状态"),
    YSY("已使用", "1", "已使用"),
    WSY("未使用", "2", "未使用"),
    BF("报废", "6", "报废");

    private String name;
    private String code;
    private String value;
    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();
    public static Map<String, String> getValue = new HashMap<>();

    static {
        for (EquipmentCategoryEnum e : EquipmentCategoryEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
            getValue.put(e.value, e.code);
        }

    }
}
