package com.yeejoin.amos.boot.module.jg.biz.data.fix.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.constant.TZSCommonConstant;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.biz.data.fix.patcher.BatchDataPatcher;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * 是否球阀数据修补处理器
 */
@Component
@Slf4j
public class WeatherTankFieldPatcher extends BatchDataPatcher {

    private final IdxBizJgRegisterInfoServiceImpl registerInfoService;

    private final ESEquipmentCategory equipmentCategory;


    protected WeatherTankFieldPatcher(ApplicationContext applicationContext, IdxBizJgRegisterInfoServiceImpl registerInfoService, ESEquipmentCategory equipmentCategory) {
        super(applicationContext);
        this.registerInfoService = registerInfoService;
        this.equipmentCategory = equipmentCategory;
    }

    @Override
    protected void patchSingleRecord(String record) {
        IdxBizJgRegisterInfo registerInfo = registerInfoService.getBaseMapper().selectOne(
                new LambdaQueryWrapper<IdxBizJgRegisterInfo>()
                        .eq(IdxBizJgRegisterInfo::getRecord, record)
                        .select(IdxBizJgRegisterInfo::getRecord,
                                TzsBaseEntity::getSequenceNbr,
                                IdxBizJgRegisterInfo::getEquCategory,
                                IdxBizJgRegisterInfo::getWhetherSphericalTank));
        // 是否球阀只在固定式压力容器式才需要
        if (registerInfo == null || !TZSCommonConstant.EQU_CATEGORY_CODE_GDYLRQ.equals(registerInfo.getEquCategory())) {
            return;
        }
        Optional<ESEquipmentCategoryDto> op = equipmentCategory.findById(registerInfo.getRecord());
        if (op.isPresent()) {
            ESEquipmentCategoryDto equipmentCategoryDto = op.get();
            equipmentCategoryDto.setWhetherSphericalTank(registerInfo.getWhetherSphericalTank());
            equipmentCategory.save(equipmentCategoryDto);
        }
    }

    @Override
    protected void beforePatching(String record) {

    }

    @Override
    protected void afterPatching(String record) {

    }

}
