package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.newEquip;

import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.useRegister.UseRegisterUpdateService;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 新增设备编辑处理器
 */
@Component
public class NewEquipDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final UseRegisterUpdateService useRegisterUpdateService;

    protected NewEquipDataChangeHandler(CommonPublisher routerEventPublisher, ApplicationContext applicationContext, UseRegisterUpdateService useRegisterUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.useRegisterUpdateService = useRegisterUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_NEW_EQUIP.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        useRegisterUpdateService.updateUseRegistrationInfo(bizId, allChangeColumns);
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return true;
    }

    @Override
    public Set<String> getEqs(String record) {
        return Collections.singleton(record);
    }

    @Override
    public Boolean bizIsFinished(String record) {
        return true;
    }

    @Override
    public Set<String> getProjectContraptionIds(String record) {
        return Collections.emptySet();
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
