package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum UscDateEnum {

    /**
     * *使用年限
     */

    FIVE_YEARS_OR_LESS("5年以下", "5"),
    FIVE_TO_TEN_YEARS("5~10年", "5-10"),
    TEN_TO_FIFTEEN_YEARS("10~15年", "10-15"),
    MORE_THAN_FIFTEEN_YEARS("15年以上", "15"),
    ;

    private String name;
    private String code;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (UscDateEnum e : UscDateEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (UscDateEnum e : UscDateEnum.values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label",e.name);
            jsonObject.put("value",e.name);
            jsonObject.put("key",e.code);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
