package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.DataHandlerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@RequestMapping(value = "/data-handler")
@Api(tags = "刷数据api")
@RequiredArgsConstructor
public class DataHandlerController {

    private final DataHandlerServiceImpl dataHandlerService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "企业数据刷入到综合统计的es", notes = "企业数据刷入到综合统计的es")
    @PutMapping(value = "/company/init2Es")
    public ResponseModel<String> init2EsCompany() {
        dataHandlerService.init2EsCompany();
        return ResponseHelper.buildResponse("success");
    }
}
