package com.yeejoin.amos.boot.module.tcm.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class QualificationProjectConverter implements Converter<String> {

    private static final Map<String,String> CODE_MAP = new HashMap<>();

    static {
        CODE_MAP.put("检验员-大型游乐设施检验","YLY");
        CODE_MAP.put("检验员-场（厂）内专用机动车辆检验","CCY");
        CODE_MAP.put("检验员-承压类设备型式试验","CXY");
        CODE_MAP.put("检验员-机电类设备型式试验","JXY");
        CODE_MAP.put("检验员-锅炉检验","GLY");
        CODE_MAP.put("检验员-锅炉能效测试","GNY");
        CODE_MAP.put("检验员-锅炉水（介）质检验-蒸汽锅炉（额定压力小于或者等于2.5MPa）、热水锅炉和有机热载体锅炉的定期检验和监督检验","GSY");
        CODE_MAP.put("检验员-锅炉水（介）质检验-热载体锅炉价值的定期检验和化学清洗过程的监督检验","GRY");
        CODE_MAP.put("检验员-压力容器检验","RQY");
        CODE_MAP.put("检验员-气瓶检验","QPY");
        CODE_MAP.put("检验员-压力管道检验","GDY");
        CODE_MAP.put("检验员-电梯检验","DTY");
        CODE_MAP.put("检验员-起重机械检验","QZY");
        CODE_MAP.put("检验员-客运索道检验","SDY");

        CODE_MAP.put("检验师-大型游乐设施检验","YLS");
        CODE_MAP.put("检验师-锅炉水（介）质检验","SZS");
        CODE_MAP.put("检验师-压力容器检验","RQS");
        CODE_MAP.put("检验师-压力管道检验","GDS");
        CODE_MAP.put("检验师-电梯检验","DTS");
        CODE_MAP.put("检验师-起重机械检验","QZS");
        CODE_MAP.put("检验师-客运索道检验","SDS");
        CODE_MAP.put("检验师-锅炉检验","GLS");
        CODE_MAP.put("检验师-场（厂）内专用机动车辆检验","CCS");

        CODE_MAP.put("机电类设备检验","JDG");
        CODE_MAP.put("承压类设备检验","CYG");
    }

    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String cellDataStr = cellData.getStringValue();
        return CODE_MAP.get(cellDataStr);
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}
