package com.yeejoin.amos.boot.module.tcm.api.dto;

import java.util.Date;
import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsJgFile;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备基本信息-维保备案信息Dto
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
public class TzsJgMaintenanceInfoDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	/**
	 * id
	 */
	private Long sequenceNbr;
	@ApiModelProperty(value = "设备唯一标识码")
	/**
	 * 设备唯一标识码
	 */
	private String sequenceCode;
	@ApiModelProperty(value = "监管系统唯一编码")
	/**
	 * 监管系统唯一编码
	 */
	private String superviseCode;
	@ApiModelProperty(value = "维保单位统一社会信用代码")
	/**
	 * 维保单位统一社会信用代码
	 */
	private String meUnitCreditCode;
	@ApiModelProperty(value = "维保单位名称")
	/**
	 * 维保单位名称
	 */
	private String meUnitName;
	@ApiModelProperty(value = "维保合同备案ID")
	/**
	 * 维保合同备案ID
	 */
	private String repairInformId;
	@ApiModelProperty(value = "维保合同开始日期")
	/**
	 * 维保合同开始日期
	 */
	private Date informStart;
	private String informStartStr;
	@ApiModelProperty(value = "维保合同结束日期")
	/**
	 * 维保合同结束日期
	 */
	private Date informEnd;
	private String informEndStr;
	@ApiModelProperty(value = "维保负责人姓名")
	/**
	 * 维保负责人姓名
	 */
	private String meMaster;
	@ApiModelProperty(value = "维保负责人身份证号")
	/**
	 * 维保负责人身份证号
	 */
	private String meMasterId;
	@ApiModelProperty(value = "紧急救援电话")
	/**
	 * 紧急救援电话
	 */
	private String emergencycall;
	@ApiModelProperty(value = "维保周期(单位：月)")
	/**
	 * 维保周期(单位：月)
	 */
	private Integer meCycle;
	@ApiModelProperty(value = "大修周期(单位：月)")
	/**
	 * 大修周期(单位：月)
	 */
	private Integer overhaulCycle;
	@ApiModelProperty(value = "24小时维保电话")
	/**
	 * 24小时维保电话
	 */
	private String me24Telephone;
	@ApiModelProperty(value = "同步时间")
	/**
	 * 同步时间
	 */
	private Date syncDate;
	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	/**
	 * 同步状态（0-新增 1-更新 2-删除）
	 */
	private Integer syncState;
	@ApiModelProperty(value = "对接公司编码")
	/**
	 * 对接公司编码
	 */
	private String appId;
	@ApiModelProperty(value = "创建时间")
	/**
	 * 创建时间
	 */
	private Date recDate;
	@ApiModelProperty(value = "操作人员")
	/**
	 * 操作人员
	 */
	private String recUserId;

	private List<TzsJgFile> repairInform;

}
