package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CheckModeEnum {
	QR("QR", "二维码巡检"),
	MOBILE("MOBILE", "移动点巡检"),
	NFC("NFC", "NFC巡检"),
	WEB("WEB", "录入检查点巡检"),
	WEB_OUT("WEB_OUT", "外来检查");
	
	private String code;
	private String message;
	
	private CheckModeEnum(String code, String message) {
		this.code = code;
		this.message = message;
	}

	public String getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	
	public static List<Map<String, Object>> getEnumList() {
		List<Map<String, Object>> list = new ArrayList<>();
		for(CheckEmailEnum e : CheckEmailEnum.values()) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("ower", e.getOwer());
			map.put("code", e.getCode());
			list.add(map);
		}
		return list;
	}
}
