package com.yeejoin.amos.patrol.business.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.patrol.common.enums.MsgTypeEnum;

import java.util.Date;

public class MsgVo {

	/**
	 * ID
	 */
	private long id;
	
	/**
	 * 用户名
	 */
	private String userName;
	
	/**
	 * 消息类型
	 */
	private String msgType;
	
	/**
	 * 消息内容
	 */
	private String msgBody;
	
	/**
	 * 发送时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date sendTime;
	
	/**
	 * 是否立即发送
	 */
	private String isImmediately;
	
	/**
	 * 定点发送时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date fixedTime;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getMsgType() {
		return msgType;
	}

	public void setMsgType(String msgType) {
		String mType = MsgTypeEnum.getEnum(msgType).getName();

		this.msgType = mType;
	}

	public String getMsgBody() {
		return msgBody;
	}

	public void setMsgBody(String msgBody) {
		this.msgBody = msgBody;
	}

	public Date getSendTime() {
		return sendTime;
	}

	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	public String getIsImmediately() {
		return isImmediately;
	}

	public void setIsImmediately(String isImmediately) {
		this.isImmediately = isImmediately;
	}

	public Date getFixedTime() {
		return fixedTime;
	}

	public void setFixedTime(Date fixedTime) {
		this.fixedTime = fixedTime;
	}
}
