package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationTransferServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Component
public class RegistrationTransferStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgChangeRegistrationTransferServiceImpl registrationTransferService;
    @Autowired
    private IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        // 获取转移详情
        Map<String, Map<String, Object>> notice = registrationTransferService.getTransferDetail(
                String.valueOf(sequenceNbr), reginParams.getCompany());

        Map<String, Object> changeTransfer = notice.get("changeRegistrationTransfer");
        if (changeTransfer == null) {
            throw new IllegalStateException("changeRegistrationTransfer 数据不存在");
        }

        Map<String, Object> basic = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.YZBG.getBusinessCode());

        String useOrgCode = Objects.toString(changeTransfer.get("useRegistrationCode"), null);
        if (useOrgCode != null) {
            LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new LambdaQueryWrapper<>();
            wrapper.select(IdxBizJgRegisterInfo::getEquList, IdxBizJgRegisterInfo::getEquCategory)
                    .eq(IdxBizJgRegisterInfo::getUseOrgCode, useOrgCode);

            IdxBizJgRegisterInfo jgRegisterInfo = idxBizJgRegisterInfoMapper.selectOne(wrapper);
            if (jgRegisterInfo != null) {
                changeTransfer.put("EQU_LIST_CODE", jgRegisterInfo.getEquList());
                changeTransfer.put("EQU_CATEGORY_CODE", jgRegisterInfo.getEquCategory());
            }
        }
        basic.put("isTempEquip", true);
        basic.put("receiveOrgCreditCode1", changeTransfer.get("receiveCompanyCode"));

        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", changeTransfer);
        result.put("basic", basic);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_CHANGE_REGISTRATION.getName();
    }
}
