package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 起重机械
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialCraneModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 起重机械载荷（t）
     */
    private String craneLoad;
    /**
     * 提升力矩（Kg/s）
     */
    private String liftingTorque;
    /**
     * 最大提升高度（m）
     */
    private String maxLiftingHeight;
    /**
     * 起升高度（主钩）(m)
     */
    private String mainLiftingHeight;
    /**
     * 起升高度（副钩）(m)
     */
    private String secLiftingHeight;
    /**
     * 工作半径（m）
     */
    private String workingRadius;
    /**
     * 工作级别
     */
    private String workLevel;
    /**
     * 轨距（m）
     */
    private String gauge;
    /**
     * 幅度（m）
     */
    private String ranges;
    /**
     * 起升速度（m/min）
     */
    private String liftingSpeed;
    /**
     * 起升速度(主钩)(m/min)
     */
    private String mainSpeedHeight;
    /**
     * 起升速度(副钩) （m/min）
     */
    private String secSpeedHeight;
    /**
     * 变幅形式
     */
    private String luffingForm;
    /**
     * 跨度（m）
     */
    private String span;
    /**
     * 额定起重量(主钩) (t)
     */
    private String mainRatedLiftingCapacity;
    /**
     * 额定起重量(副钩)(t)
     */
    private String secRatedLiftingCapacity;
    /**
     * 大车运行速度（m/min）
     */
    private String bigCarSpeed;
    /**
     * 小车运行速度（m/min）
     */
    private String smallCarSpeed;

}
