package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterResourceDto", description = "水资源")
public class WaterResourceDto extends BaseDto {
	@ExcelIgnore
	@ApiModelProperty(value = "机构/部门名称")
	private String bizOrgName;
	@ExcelIgnore
	@ApiModelProperty(value = "机构编码")
	private String bizOrgCode;

	@ExcelIgnore
	private static final long serialVersionUID = 1L;

	@ExcelProperty(value = "名称", index = 0)
	@ApiModelProperty(value = "资源名称")
	private String name;

	@ExcelProperty(value = "地址", index = 1)
	@ApiModelProperty(value = "地址")
	private String address;

	@ExcelIgnore
	@ApiModelProperty(value = "资源类型（消火栓：hydrant、消防水鹤：crane、天然水源：natural、消防水池：pool）")
	private String resourceType;

	@ExplicitConstraint(type = "XFSYLX", indexNum = 2, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "资源类型", index = 2)
	@ApiModelProperty(value = "资源类型名称（消火栓、消防水鹤、天然水源、消防水池）")
	private String resourceTypeName;

	@ExcelIgnore
	@ApiModelProperty(value = "所在建筑id")
	private Long belongBuildingId;

	@ExplicitConstraint(indexNum = 3, sourceClass = CommonExplicitConstraint.class, method = "getBuildingList")
	@ExcelProperty(value = "所在建筑", index = 3)
	@ApiModelProperty(value = "所在建筑")
	private String belongBuilding;

	@ExcelIgnore
	@ApiModelProperty(value = "所属消防系统id")
	private Long belongFightingSystemId;

	@ExplicitConstraint(indexNum = 4, sourceClass = CommonExplicitConstraint.class, method = "getFireSystemList")
	@ExcelProperty(value = "所属消防系统", index = 4)
	@ApiModelProperty(value = "所属消防系统")
	private String belongFightingSystem;

	@ExcelIgnore
	@ApiModelProperty(value = "管理单位id")
	private Long managementUnitId;

	@ExplicitConstraint(indexNum = 9, sourceClass = CommonExplicitConstraint.class, method = "getWaterCompanyList")
	@ExcelProperty(value = "管理单位", index = 9)
	@ApiModelProperty(value = "管理单位")
	private String managementUnit;

	@ExcelIgnore
	@ApiModelProperty(value = "维保单位id")
	private Long maintenanceUnitId;

	@ExplicitConstraint(indexNum = 10, sourceClass = CommonExplicitConstraint.class, method = "getCompanyList")
	@ExcelProperty(value = "维保单位", index = 10)
	@ApiModelProperty(value = "维保单位")
	private String maintenanceUnit;

	@ExcelProperty(value = "建造日期", index = 7)
	@ApiModelProperty(value = "建造日期")
	private Date buildDate;

	@ExcelProperty(value = "启用日期", index = 8)
	@ApiModelProperty(value = "启用日期")
	private Date enableDate;

	@ExcelIgnore
	@ApiModelProperty(value = "方位图集合")
	private List<Object> orientationImgList;

	@ExcelIgnore
	@ApiModelProperty(value = "实景图集合")
	private List<Object> realityImgList;

	@ExcelIgnore
	@ApiModelProperty(value = "方位图")
	private String orientationImg;

	@ExcelIgnore
	@ApiModelProperty(value = "实景图")
	private String realityImg;

	@ExplicitConstraint(indexNum = 38, sourceClass = CommonExplicitConstraint.class, method = "getContactUser")
	@ExcelProperty(value = "联系人姓名", index = 38)
	@ApiModelProperty(value = "联系人姓名")
	private String contactUser;

	/**
	 * 联系人姓名id
	 */
	@ExcelIgnore
	@TableField("contact_user_id")
	private String contactUserId;

	@ExcelProperty(value = "联系人电话", index = 39)
	@ApiModelProperty(value = "联系人电话")
	private String contactPhone;

	@ExcelIgnore
	@ApiModelProperty(value = "是否有物联参数（1有，0没有）")
	private Boolean isIot;

	@ExcelIgnore
	@ApiModelProperty(value = "消防救援机构_通用唯一识别码")
	private String rescueOrgCode;

	@ExcelIgnore
	@ApiModelProperty(value = "行政区划代码")
	private String administrativeCode;

	@ExcelIgnore
	@ApiModelProperty(value = "更新人员")
	private String recUserName;

	@ExcelIgnore
	@ApiModelProperty(value = "组织机构代码")
	private String orgCode;

	@ExcelIgnore
	@ApiModelProperty(value = "资源id")
	private Long resourceId;

	@ExcelProperty(value = "高度（cm）", index = 11)
	@ApiModelProperty(value = "高度（cm）")
	private float height;

	@ExcelIgnore
	@ApiModelProperty(value = "水源可用状态类别代码")
	private String statusCode;

	@ExplicitConstraint(type = "SYZT", indexNum = 12, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "水源可用状态", index = 12)
	@ApiModelProperty(value = "水源可用状态类别名称")
	private String status;

	@ExcelProperty(value = "所属路段", index = 13)
	@ApiModelProperty(value = "所属路段")
	private String section;

	@ExcelProperty(value = "所属管网", index = 14)
	@ApiModelProperty(value = "所属管网")
	private String pipeNetwork;

	@ExcelIgnore
	@ApiModelProperty(value = "消防给水管网形式类型代码")
	private String pipeTypeCode;

	@ExplicitConstraint(type = "XFJSGW", indexNum = 15, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消防给水管网形式", index = 15)
	@ApiModelProperty(value = "消防给水管网形式")
	private String pipeTypeName;

	@ExcelProperty(value = "管网直径（cm）", index = 16)
	@ApiModelProperty(value = "管网直径（cm）")
	private float pipeDiameter;

	@ExcelProperty(value = "进水管直径(cm)", index = 17)
	@ApiModelProperty(value = "进水管直径(cm)")
	private float inletPipeDiameter;

	@ExcelProperty(value = "出水管直径(cm)", index = 18)
	@ApiModelProperty(value = "出水管直径(cm)")
	private float outletPipeDiameter;

	@ExcelProperty(value = "加水车道数量(个)", index = 19)
	@ApiModelProperty(value = "加水车道数量(个)")
	private Integer waterfillingLaneNum;

	@ExcelProperty(value = "供水单位名称", index = 20)
	@ApiModelProperty(value = "供水单位名称")
	private String waterSupplyName;

	@ExplicitConstraint(type = "XHSXTLX", indexNum = 21, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消火栓系统类型", index = 21)
	@ApiModelProperty(value = "消火栓系统类型")
	private String systemType;

	@ExcelIgnore
	@ApiModelProperty(value = "消火栓系统类型code")
	private String systemTypeCode;

	@ExcelProperty(value = "消防设施状况", index = 22)
	@ApiModelProperty(value = "消防设施状况分类")
	private String facilitiesCategory;

	@ExcelIgnore
	@ApiModelProperty(value = "消防设施状况分类code")
	private String facilitiesCategoryCode;

	@ExcelProperty(value = "道路路口路段", index = 23)
	@ApiModelProperty(value = "道路路口路段简要情况")
	private String roadJunctionInfo;

	@ExplicitConstraint(type = "XHSFZXS", indexNum = 24, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消火栓放置形式", index = 24)
	@ApiModelProperty(value = "消火栓放置形式")
	private String placeForm;

	@ExcelIgnore
	@ApiModelProperty(value = "消火栓放置形式code")
	private String placeFormCode;

	@ExplicitConstraint(type = "XFSDJK", indexNum = 25, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消防水带接口", index = 25)
	@ApiModelProperty(value = "消防水带接口")
	private String hoseConnection;

	@ExcelIgnore
	@ApiModelProperty(value = "消防水带接口code")
	private String hoseConnectionCode;

	@ExplicitConstraint(type = "QSXS", indexNum = 26, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "取水形式", index = 26)
	@ApiModelProperty(value = "取水形式")
	private String intakeForm;

	@ExcelIgnore
	@ApiModelProperty(value = "水源类型代码")
	private String typeCode;

	@ExplicitConstraint(type = "TRSYLX", indexNum = 27, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "水源类型", index = 27)
	@ApiModelProperty(value = "水源类型")
	private String type;

	@ExcelProperty(value = "容积（m³）", index = 28)
	@ApiModelProperty(value = "容积（m³）")
	private float volume;

	@ExcelProperty(value = "面积（㎡）", index = 29)
	@ApiModelProperty(value = "面积（㎡）")
	private float area;

	@ExcelProperty(value = "水质情况", index = 30)
	@ApiModelProperty(value = "水质情况")
	private String qualitySituationInfo;

	@ExcelProperty(value = "四季变化简要情况", index = 31)
	@ApiModelProperty(value = "四季变化简要情况")
	private String seasonChangeInfo;

//    @ExplicitConstraint(indexNum = 32, source = {"0", "1"}) //固定下拉内容
//    @ExcelProperty(value = "有无枯水期", index = 32)
	@ExcelIgnore
	@ApiModelProperty(value = "有无枯水期")
	private Boolean hasDrySeason;

	@ExplicitConstraint(indexNum = 32, source = { "有", "无" }) // 固定下拉内容
	@ExcelProperty(value = "有无枯水期", index = 32)
	@ApiModelProperty(value = "有无枯水期")
	private String hasDrySeasonType;

	@ExcelProperty(value = "枯水期跨度简要情况", index = 33)
	@ApiModelProperty(value = "枯水期跨度简要情况")
	private String dryPeriodSpan;

	@ExcelProperty(value = "取水高度(cm)", index = 34)
	@ApiModelProperty(value = "取水高度(cm)")
	private float intakeHeight;

	@ExcelProperty(value = "水源标高差(cm)", index = 35)
	@ApiModelProperty(value = "水源标高差(cm)")
	private float elevationDifference;

	@ExcelProperty(value = "停车位置", index = 36)
	@ApiModelProperty(value = "停车位置")
	private String parkingPosition;

	@ExcelProperty(value = "停车数量(个)", index = 37)
	@ApiModelProperty(value = "停车数量(个)")
	private int parkingNum;

	// 物联参数改为动态加载，原先字段作废，字段做隐藏
	@ExcelIgnore
	@ApiModelProperty(value = "储水量容积物联编码")
	private String iotWaterStorage;

	@ExcelIgnore
	@ApiModelProperty(value = "流量物联编码")
	private String iotFlowRate;

	@ExcelIgnore
	@ApiModelProperty(value = "状态物联编码")
	private String iotStatus;

	// BUG 2920 管网压力字段冗余 2021-09-18 陈召
	@ExcelIgnore
	@ApiModelProperty(value = "管网压力物联编码")
	private String iotPipePressure;

	@ExcelIgnore
	@ApiModelProperty(value = "物联参数")
	private Map<String, Object> waterResourceIotDto;

	@ExcelIgnore
	@ApiModelProperty("设施定义id")
	private Long equipId;

	@ApiModelProperty("设施定义名称")
	@ExcelProperty(value = "设施定义名称", index = 5)
	@ExplicitConstraint(indexNum = 5, sourceClass = CommonExplicitConstraint.class, method = "getEquipDefinition")
	private String equipName;

	@ExcelIgnore
	@ApiModelProperty("设施分类id")
	private Long equipCategoryId;
	// BUG 2935 优化项 分类从93060000 取得字典数据 by kongfm 2021-09-17
	@ApiModelProperty("设施分类名称")
	@ExcelIgnore
//    @ExplicitConstraint(indexNum = 42, sourceClass = CommonExplicitConstraint.class, method = "getEquipCategory")
//    @ExcelProperty(value = "设施分类名称", index = 42)
	private String equipCategoryName;
	
	@ApiModelProperty("设施分类编码")
	@ExcelIgnore
	private String equipCategoryCode;

	@ApiModelProperty("设施编码")
	@ExcelIgnore
	private String equipCode;

	@ApiModelProperty("维保周期")
	@ExcelProperty(value = "维保周期(月)", index = 6)
	private String maintenancePeriod;

	@ApiModelProperty(value = "经度")
	@ExcelProperty(value = "经度", index = 40)
	private Double longitude;

	@ApiModelProperty(value = "纬度")
	@ExcelProperty(value = "纬度", index = 41)
	private Double latitude;

	@ExcelProperty(value = "消火栓类型", index =42)
	@ExplicitConstraint(type = "HSLX",indexNum = 42, sourceClass = CommonExplicitConstraint.class)
	@ApiModelProperty(value = "消火栓类型")
	@TableField(exist = false)
	private String hydrantType;

	@ExcelIgnore
	@ApiModelProperty(value = "附件")
	@TableField(exist = false)
	private Map<String, List<AttachmentDto>> attachments;
}
