package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_index")
@ApiModel(value = "PerfQuotaIot", description = "消防装备/消防车指标")
public class EquipmentIndex extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableField(value = "id")
    private Long id;
    /**
     * 装备关联id
     */
    @TableField(value = "equipment_id")
    private String equipmentId;
    /**
     * 指标名称
     */
    @TableField(value = "name")
    private String perfQuotaName;
    /**
     * 指标key
     */
    @TableField(value = "name_key")
    private String perfQuotaDefinitionId;
    /**
     * 指标单位
     */
    @TableField(value = "unit")
    private String unitName;

    /**
     * 指标值枚举
     */
    @TableField("value_enum")
    private String valueEnum;

    /**
     * 是否物联
     */
    @TableField(value = "is_iot")
    private Boolean isIot;
    /**
     * 物联类型
     */
    @TableField(value = "type_name")
    private String typeName;
    /**
     * 物联类型id
     */
    @TableField(value = "type_code")
    private String typeCode;
    /**
     * 分组
     */
    @TableField(value = "group_name")
    private String groupName;
    /**
     * 指标id
     */
    @TableField(value = "index_definition_id")
    private String indexId;
    /**
     * 是否是核心参数
     */
    @TableField(exist = false)
    private Boolean isImportentParameter;

    @TableField(exist = false)
    private String perfGroupCode;

    /**
     * 排序
     */
    @TableField(value = "sort_num")
    private Integer sortNum;

    /**
     * 类型--冗余字段，暂时无用
     */
    @TableField(value = "type")
    private Integer type;


    @TableField(value = "perf_value")
    private String perfValue;


    /**
     * 性能指标(临时)
     */
    @Transient
    @TableField(exist = false)
    private String perfQuotaStr;

    /**
     * 是否支持趋势查看
     */
    @TableField(value = "is_trend")
    private Boolean isTrend;
}
