package com.yeejoin.equipmanage.common.enums;

/**
 * @Author: xl
 * @Description:
 * @Date: 2021/9/13 11:17
 */
public class TemperatureAlarm {

    //规则温度
    private Double ruleTemperature;
    //当前温度
    private Double currTemperature;
    //测温单位
    private String thermometryUnit;

    public enum AlarmLevel {
        alarmLevel_0("0", "预警"),
        alarmLevel_1("1", "报警");

        String key;
        String desc;

        private AlarmLevel(String key, String desc) {
            this.key = key;
            this.desc = desc;
        }
        public String getKey() {
            return key;
        }
        public String getDesc() {
            return desc;
        }

        public static String getDescByKey(String key){
            for (AlarmLevel constants : values()) {
                if (constants.getKey().equals(key)) {
                    return constants.getDesc();
                }
            }
            return null;
        }
    }

    public enum AlarmType {
        alarmType_0("0", "最高温度"),
        alarmType_1("1", "最低温度"),
        alarmType_2("1", "平均温度");

        String key;
        String desc;

        private AlarmType(String key, String desc) {
            this.key = key;
            this.desc = desc;
        }
        public String getKey() {
            return key;
        }
        public String getDesc() {
            return desc;
        }

        public static String getDescByKey(String key){
            for (AlarmType constants : values()) {
                if (constants.getKey().equals(key)) {
                    return constants.getDesc();
                }
            }
            return null;
        }
    }

    public enum AlarmRule {
        alarmRule_0("0", "大于", ">"),
        aalarmRule_1("1", "小于", "<");

        String key;
        String desc;
        String value;

        private AlarmRule(String key, String desc, String value) {
            this.key = key;
            this.desc = desc;
            this.value = value;
        }
        public String getKey() {
            return key;
        }
        public String getDesc() {
            return desc;
        }

        public static String getDescByKey(String key){
            for (AlarmRule constants : values()) {
                if (constants.getKey().equals(key)) {
                    return constants.getDesc();
                }
            }
            return null;
        }
    }

    public static String getAlarmContent(String alarmLevel, String alarmType, String alarmRule, Double ruleTemperature,
                                    Double currTemperature, String thermometryUnit) {
        String str = "温度报警：";
        String alarmRuleDesc = AlarmRule.getDescByKey(alarmRule);
        if ("大于".equals(alarmRuleDesc)){
            str += AlarmLevel.getDescByKey(alarmLevel) + AlarmType.getDescByKey(alarmType) + alarmRuleDesc
                    + ruleTemperature;
        } else if ("小于".equals(alarmRuleDesc)) {
            str += AlarmLevel.getDescByKey(alarmLevel) + AlarmType.getDescByKey(alarmType) + alarmRuleDesc
                    + ruleTemperature;
        }

        return str;
    }
}
