package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class DictParamsConverter implements Converter<String> {

    private static final Map<String, String> dictMap = new HashMap<>();

    static {
        // 填充映射关系
        dictMap.put("油", "5961");
        dictMap.put("电", "5962");
        dictMap.put("煤", "5963");
        dictMap.put("水煤浆", "5964");
        dictMap.put("生物质", "5965");
        dictMap.put("余热", "5966");
        dictMap.put("其他", "5967");
        dictMap.put("射线", "5969");
        dictMap.put("超声", "5970");
        dictMap.put("磁粉", "5971");
        dictMap.put("渗透", "5972");
        dictMap.put("固定式", "5990");
        dictMap.put("半挂式", "5991");
        dictMap.put("公用管道", "5992");
        dictMap.put("工业管道", "5993");
        dictMap.put("锅筒(锅壳)", "6005");
        dictMap.put("过热器出口集箱", "6006");
        dictMap.put("启动分离器", "6007");
        dictMap.put("长输管道", "5994");
        dictMap.put("磁粉", "5988");
        dictMap.put("射线", "5986");
        dictMap.put("超声", "5987");
        dictMap.put("渗透", "5989");
        dictMap.put("A1", "6094");
        dictMap.put("A2", "6095");
        dictMap.put("A7", "6100");
        dictMap.put("A8", "6101");
        dictMap.put("A3", "6096");
        dictMap.put("A4", "6097");
        dictMap.put("A5", "6098");
        dictMap.put("A6", "6099");
        dictMap.put("牵引索", "6167");
        dictMap.put("平衡索", "6168");
        dictMap.put("Ⅰ类", "1");
        dictMap.put("Ⅱ类", "2");
        dictMap.put("Ⅲ类", "3");
        dictMap.put("ⅢA类", "4");
        dictMap.put("ⅢB类", "5");
        dictMap.put("ⅢC类", "6");
        dictMap.put("M1", "6531");
        dictMap.put("M2", "6532");
        dictMap.put("M3", "6533");
        dictMap.put("M4", "6534");
        dictMap.put("M5", "6535");
        dictMap.put("M6", "6536");
        dictMap.put("M7", "6537");
        dictMap.put("M8", "6538");
        dictMap.put("M9", "6539");
        dictMap.put("M10", "6540");
        dictMap.put("A级", "5957");
        dictMap.put("B级", "5958");
        dictMap.put("C级", "5959");
        dictMap.put("D级", "5960");
        dictMap.put("GC1", "6002");
        dictMap.put("GC2", "6003");
        dictMap.put("GC3", "6004");
        dictMap.put("压缩天然气", "COMPRESSED_NATURAL_GAS");
        dictMap.put("液化天然气", "LIQUEFIED_NATURAL_GAS");
        dictMap.put("液化石油气", "LIQUEFIED_PETROLEUM_GAS");
        dictMap.put("氢气", "HYDROGEN");
        dictMap.put("集选", "1");
        dictMap.put("并联", "2");
        dictMap.put("按钮", "3");
        dictMap.put("其他控制方式", "4");
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return dictMap.getOrDefault(cellValue, null);
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }
}