package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 使用登记状态西悉尼
 */
@Getter
@AllArgsConstructor
public enum WorkFlowStatusEnum {

    /**
     * 使用登记流程
     */
    USE_SUBMIT("使用单位提交", "useSubmit", "使用单位待提交", "一级受理已驳回", "使用单位已撤回"),
    USE_RECEIVE("一级受理", "useReceive", "一级待受理", "已驳回", "一级受理已撤回"),
    USE_SAFETY_CHECK("安全监察受理", "safetyCheck", "安全监察待受理", "二级受理已驳回", "安全监察已撤回"),
    USE_PRELIMINARY("二级受理", "usePreliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    USE_REEXAMINE("三级受理", "useReexamine", "三级待受理","",""),

    /**
     * 维保备案
     */
    MAIN_SUBMIT("使用单位提交", "mainSubmit", "使用单位待提交", "维保单位已驳回", "使用单位已撤回"),
    MAIN_RECEIVE("维保单位审核确认", "mainReceive", "维保单位待受理", "监管单位已驳回", "维保单位已撤回"),
    MAIN_PRELIMINARY("监管单位审核", "mainPreliminary", "监管单位待受理", "", ""),


    /**
     * 电梯注销
     */
    CANCEL_SUBMIT("使用单位提交", "cancelSubmit", "使用单位待提交", "一级受理已驳回", "使用单位已撤回"),
    CANCEL_RECEIVE("一级受理", "cancelReceive", "一级待受理", "二级受理已驳回", "一级受理已撤回"),
    CANCEL_PRELIMINARY("二级受理", "cancelPreliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    CANCEL_REEXAMINE("三级受理", "cancelReexamine", "三级待受理", "", ""),

    /**
     * 改造登记流程
     */
    CHANGE_SUBMIT("使用单位提交", "changeSubmit", "使用单位待提交", "一级受理已驳回", "使用单位已撤回"),
    CHANGE_RECEIVE("一级受理", "changeReceive", "一级待受理", "二级受理已驳回", "一级受理已撤回"),
    CHANGE_PRELIMINARY("二级受理", "changePreliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    CHANGE_REEXAMINE("三级受理", "changeReexamine", "三级待受理", "", ""),

    /**
     * 更名变更登记流程
     */
    UNIT_RENAME_SUBMIT("使用单位提交", "unitRenameSubmit", "使用单位待提交", "一级受理已驳回", "使用单位已撤回"),
    UNIT_RENAME_RECEIVE("一级受理", "unitRenameReceive", "一级待受理", "二级受理已驳回", "一级受理已撤回"),
    UNIT_RENAME_PRELIMINARY("二级受理", "unitRenamePreliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    UNIT_RENAME_REEXAMINE("三级受理", "unitRenameReexamine", "三级待受理", "", ""),


    /**
     * 移装变更登记流程
     */
    TRANSFER_SUBMIT("使用单位提交", "transferSubmit", "使用单位待提交", "一级受理已驳回", "使用单位已撤回"),
    TRANSFER_RECEIVE("一级受理", "transferReceive", "一级待受理", "二级受理已驳回", "一级受理已撤回"),
    TRANSFER_PRELIMINARY("二级受理", "transferPreliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    TRANSFER_REEXAMINE("三级受理", "transferReexamine", "三级待受理","",""),

    /**
     * 使用单位更登记流程
     */
    UNITCHANGE_SUBMIT("使用单位提交", "unitChangeSubmit", "使用单位待提交", "一级受理已驳回", "使用单位已撤回"),
    UNITCHANGE_RECEIVE("一级受理", "unitChangeReceive", "一级待受理", "二级受理已驳回", "一级受理已撤回"),
    UNITCHANGE_PRELIMINARY("二级受理", "unitChangePreliminary", "二级待受理", "三级受理已驳回", "二级受理已撤回"),
    UNITCHANGE_REEXAMINE("三级受理", "unitChangeReexamine", "三级待受理","",""),



    /**
     * 停用启用流程
     */
    ENABLE_SUBMIT("使用单位提交", "enableSubmit", "待提交", "已驳回", "已撤回"),
    ENABLE_RECEIVE("监管受理", "enableReceive", "待受理", "", "");


    private final String name;

    private final String code;

    private final String pass;

    private final String reject;

    private final String rollBack;



    public static WorkFlowStatusEnum getMessage(String code){
        for (WorkFlowStatusEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants;
            }
        }
        return null;
    }

    public static List<Map<String, String>> getInfoList(String code) {
        List<Map<String, String>> resultList = new ArrayList<>();
        for (WorkFlowStatusEnum constants : values()) {
            if (constants.getCode().startsWith(code)) {
                HashMap<String, String> hashMap = new HashMap<>();
                hashMap.put("name", constants.getPass());
                hashMap.put("value", constants.getPass());
                resultList.add(hashMap);
                HashMap<String, String> hashMap1 = new HashMap<>();
                hashMap1.put("name", constants.getReject());
                hashMap1.put("value", constants.getReject());
                resultList.add(hashMap1);
                HashMap<String, String> hashMap2 = new HashMap<>();
                hashMap2.put("name", constants.getRollBack());
                hashMap2.put("value", constants.getRollBack());
                resultList.add(hashMap2);
            }
        }
        HashMap<String, String> hashMap = new HashMap<>();
        hashMap.put("name", "已完成");
        hashMap.put("value", "已完成");
        resultList.add(hashMap);
        return resultList;
    }
}
