package com.yeejoin.amos.boot.module.ys.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 应急预案管理
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "YsEmergencyPlanDto", description = "应急预案管理")
public class YsEmergencyPlanDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "关联对象id")
    private String businessId;

    @ApiModelProperty(value = "关联对象类型")
    private String type;

    @ApiModelProperty(value = "预案类别")
    private String planCategory;

    @ApiModelProperty(value = "预案类型")
    private String planType;

    @ApiModelProperty(value = "预案名称")
    private String planName;

    @ApiModelProperty(value = "预案文件")
    private JSONArray planFile;

    @ApiModelProperty(value = "预案类别id")
    private String planCategoryId;

    @ApiModelProperty(value = "预案时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date planTime;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "发布状态")
    private String publish;
}
