package com.yeejoin.amos.boot.module.jczs.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
/**
 * 特种设备附件资料信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tz_jg_enclosure_info")
@ApiModel(value="TzsJgEnclosureInfo对象", description="特种设备附件资料信息")
public class TzsJgEnclosureInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备资料编号")
    private String equDataNo;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "设备资料类型")
    private String equDataType;

    @ApiModelProperty(value = "附件资料格式")
    private String enclosureFormat;

    @ApiModelProperty(value = "附件资料名称")
    private String enclosureName;

    @ApiModelProperty(value = "附件资料完整路径")
    private String enclosureUrl;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;


}
