package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tcm.api.entity.ThreeSystems;
import com.yeejoin.amos.boot.module.tcm.api.service.IThreeSystemsService;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.TzsUserInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@RestController
@Api(tags = "三个制度统计")
@RequestMapping(value = "/threeProvisions")
public class ThreeSystemsController<string> extends BaseController {
	private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";
	@Autowired
	RedisUtils redisUtils;
	@Autowired
	private IThreeSystemsService iThreeSystemsService;
	@Autowired
	private TzsUserInfoServiceImpl tzsUserInfoServiceImpl;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getStatisticsMessage")
	@ApiOperation(httpMethod = "GET", value = "监管单位三个规定统计信息", notes = "监管单位三个规定统计信息")
	public ResponseModel<Object> getStatisticsMessage(@RequestParam("sequenceNbr") String sequenceNbr,
	                                                  @RequestParam(value = "planType", defaultValue = "1") String planType,
	                                                  @RequestParam(value = "startDate",required = false) String startDate,
	                                                  @RequestParam(value = "endDate", required = false) String endDate) {
		List<LinkedHashMap> data = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
		ArrayList<LinkedHashMap> result = new ArrayList<>();
		List<LinkedHashMap> list = tzsUserInfoServiceImpl.screenData(result, data, sequenceNbr);
		Page<ThreeSystems> threeSystemsPage = new Page<>();
		try {
			threeSystemsPage.setRecords(iThreeSystemsService.getStatisticsMessage(list, planType, startDate, endDate));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return ResponseHelper.buildResponse(threeSystemsPage);
	}


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getThreeSystemsStatistics")
    @ApiOperation(httpMethod = "GET", value = "生成三项制度统计", notes = "生成三项制度统计")
    public ResponseModel<Object> getThreeSystemsStatistics(@RequestParam(value = "type") String type) {
        iThreeSystemsService.getThreeSystemsStatistics(type);
        return ResponseHelper.buildResponse("ok");
    }

}
