package com.yeejoin.amos.boot.module.ys.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ys.api.dto.YsEmergencyCaseDto;
import com.yeejoin.amos.boot.module.ys.api.service.IYsEmergencyCaseService;
import com.yeejoin.amos.boot.module.ys.biz.service.impl.YsEmergencyCaseServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author system_generator
 * @date 2024-09-24
 */
@RestController
@Api(tags = "救援案例管理")
@RequestMapping(value = "/ys-emergency-case")
public class YsEmergencyCaseController extends BaseController {

	@Autowired
	private IYsEmergencyCaseService iYsEmergencyCaseService;
    @Autowired
    YsEmergencyCaseServiceImpl ysEmergencyCaseServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<YsEmergencyCaseDto> save(@RequestBody YsEmergencyCaseDto model) {
	    model = ysEmergencyCaseServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
	 * 新增或者更新
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveOrUpdate")
	@ApiOperation(httpMethod = "POST", value = "新增或者更新", notes = "新增或者更新")
	public ResponseModel<Boolean> saveOrUpdate(@RequestBody YsEmergencyCaseDto model) {
		AgencyUserModel userModel = getSelectedOrgInfo().getUserModel();
		return ResponseHelper.buildResponse(iYsEmergencyCaseService.saveOrUpdate(model, userModel));
	}


	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<YsEmergencyCaseDto> updateBySequenceNbrYsEmergencyCase(@RequestBody YsEmergencyCaseDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(ysEmergencyCaseServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/deleteById")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
	public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") String sequenceNbr){
		return ResponseHelper.buildResponse(iYsEmergencyCaseService.deleteById(sequenceNbr));
	}


    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/detail")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<YsEmergencyCaseDto> selectOne(@RequestParam String sequenceNbr) {
		return ResponseHelper.buildResponse(iYsEmergencyCaseService.queryBySequenceNbr(sequenceNbr));
	}



	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<YsEmergencyCaseDto>> queryForPage(@RequestParam(value = "current") int current,
																@RequestParam(value = "size") int size,
																@RequestParam(value = "sort", required = false) String sort,
																YsEmergencyCaseDto dto) {
	    Page<YsEmergencyCaseDto> page = new Page<YsEmergencyCaseDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(ysEmergencyCaseServiceImpl.queryForYsEmergencyCasePage(page, sort, dto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<YsEmergencyCaseDto>> selectForList() {
	    return ResponseHelper.buildResponse(ysEmergencyCaseServiceImpl.queryForYsEmergencyCaseList());
	}


	/**
	 *数据导出
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "列表数据导出", notes = "列表数据导出")
	public void expertDataExport(HttpServletResponse response, String ids) {
		Assert.hasText(ids,"未选择导出数据");
		ysEmergencyCaseServiceImpl.export(response,Arrays.asList(ids.split(",")));
	}
	/**
	 *数据导入
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/import")
	@ApiOperation(httpMethod = "POST", value = "救援案例列表数据导入", notes = "救援案例列表数据导入")
	@CrossOrigin("*")
	public ResponseModel<Object> expertDataImport(@RequestBody MultipartFile file) {
		// 校验文件是否为空
		if (file.isEmpty()) {
			return ResponseHelper.buildResponse("文件不能为空");
		}
		// 校验文件类型为 Excel
		String contentType = file.getContentType();
		String fileExtension = FilenameUtils.getExtension(file.getOriginalFilename());
		// 校验 Excel 文件的 MIME type 和扩展名
		if (!("application/vnd.ms-excel".equals(contentType) ||
				"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType)) ||
				!("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
			return ResponseHelper.buildResponse("文件类型必须是 Excel 文件");
		}
		AgencyUserModel userModel = getSelectedOrgInfo().getUserModel();
		return ysEmergencyCaseServiceImpl.expertDataImport(file,userModel);
	}
}
