package com.yeejoin.amos.boot.module.jg.api.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jg.api.bo.JgBizCountDataBO;
import com.yeejoin.amos.boot.module.jg.api.dto.ReportAnalysisSearchDTO;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 装备分类 Mapper 接口
 *
 * @author system_generator
 * @date 2021-10-20
 */
public interface CommonMapper extends BaseMapper<EquipmentCategory> {

    List<Map<String, Object>> getUnitListByType(String type);

    List<Map<String, Object>> getSecurityAdmin(String companyCode, String type);

    Map<String, Object> getUserInfo(String sequenceNbr);

    Map<String,Object> getEnterpriseInfo(String useCode);

    List<Map<String,Object>> getEnterpriseEmployee(String unitCode);

    String getOrgCodeByCompanyCode(String companyCode);

    String selectBusinessData(String tableName, String instanceId);

    String selectPromoterData(String tableName, String instanceId);

    void updateBusinessData(String tableName,String assignee, String transferToUserIds, String instanceId,String nextTaskId);

    Map<String, Object> getUserPhone(String name ,String companyCode);


    List<Map<String, String>> equOnJgServiceOperationRecords(String record);

    /**
     * 统计指定设备流程中的引用次数（12个流程中，非待提交、非已撤回、非已驳回）
     * @param record 设备唯一标识
     * @return 被引用次数 > 0 则设备不可编辑
     */
    Integer countEquipInUseTimesForEdit(String record);


    /**
     * 统计设备被引用的次数（只有存在就算引用）
     * @param record 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    Integer countEquipInUseTimesForDel(String record);


    List<String> refreshTheDetailsDataOfCompletedUsageRegistration(String since);

    /**
     * 按照 地市或者区县查询所在的地市code
     * @param receiveCompanyCode 地市或者区县code
     * @param exclusionIds 需要排除的区县
     * @return 地市code
     */
    String selectCityCompanyCode(@Param("receiveCompanyCode") String receiveCompanyCode, @Param("exclusionIds") String[] exclusionIds);


    /**
     * 告知业务统计
     * @param reportAnalysisSearchDTO 条件
     * @return 过程数据
     */
    List<JgBizCountDataBO> queryForNoticeCountData(@Param("param") ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    List<CompanyBo> queryJGCompanyCodeName(String orgCode);

    /**
     * 维保备案统计数据查询
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountDataBO>
     */
    List<JgBizCountDataBO> queryForMaintenanceCountData(@Param("param") ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    /**
     * 登记类统计数据查询
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountDataBO>
     */
    List<JgBizCountDataBO> queryForRegisterCountData(@Param("param") ReportAnalysisSearchDTO reportAnalysisSearchDTO);


    /**
     * 单位详情
     * @param companyCode
     * @return CompanyBo
     */
    CompanyBo queryCompanyInfoByCode(String companyCode);

    /**
     * 车用气瓶登记业务办理里面的 出厂编号/产品编码 要校验唯一性（产品编号在车用气瓶范围内全局唯一）
     * @param factoryNum
     * @return
     */
    Integer checkFactoryNumUniquenessForVehicleCylinder(String factoryNum,String sequenceNbr);

    /**
     * 查询维保超期的设备
     * */
    List<Map<String, Object>> queryOutOfMaintenanceRecord();

    List<Map<String, Object>> queryOutOfInspectionRecord();

    /**
     * 大屏业务全过程统计已经完成的单据
     *
     * @param orgCode 行政区划对应公司的orgCode
     * @param dpFilterParamDto 过滤条件
     * @return 统计数量数组
     */
    List<Long> countBizFinishedNumForDP(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    /**
     * 大屏大屏业务全过程统计流程中(包括已经完成)的单据
     *
     * @param orgCode 行政区划对应公司的orgCode
     * @param dpFilterParamDto 过滤条件
     * @return 统计数量数组
     */
    List<Long> countAllInFlowingForDPNoFinishedBizData(@Param("orgCode")String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Map<String, String>> getOrgCodesByCompanyCodes(@Param("regionCodes") List<Integer> regionCodes);
}

