package com.yeejoin.amos.boot.module.jg.biz.init;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.service.IEquipUsedCheck;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.List;

/**
 * @author Administrator
 */
@Component
public class ApplicationRunnerImpl implements ApplicationRunner {
    private JgUseRegistrationServiceImpl useRegistrationService;

    private CommonServiceImpl commonService;

    private JgInstallationNoticeServiceImpl installationNoticeService;

    private JgMaintainNoticeServiceImpl jgMaintainNoticeService;

    private JgReformNoticeServiceImpl jgReformNoticeService;

    private JgTransferNoticeServiceImpl jgTransferNoticeService;

    private JgEquipTransferServiceImpl jgEquipTransferService;

    private JgChangeRegistrationTransferServiceImpl changeRegistrationTransferService;

    private JgChangeRegistrationReformServiceImpl changeRegistrationReformService;

    private JgChangeRegistrationUnitServiceImpl changeRegistrationUnitService;

    private JgEnableDisableServiceImpl jgEnableDisableService;

    private JgMaintenanceContractServiceImpl maintenanceContractService;

    private JgScrapCancelServiceImpl scrapCancelService;

    private JgChangeRegistrationNameServiceImpl changeRegistrationNameService;

    private ReportAnalysisServiceImpl reportAnalysisService;

    private List<IEquipUsedCheck> equipUsedCheckList;


    public ApplicationRunnerImpl(JgUseRegistrationServiceImpl useRegistrationService,
                                 CommonServiceImpl commonService,
                                 JgInstallationNoticeServiceImpl installationNoticeService,
                                 JgMaintainNoticeServiceImpl jgMaintainNoticeService,
                                 JgReformNoticeServiceImpl jgReformNoticeService,
                                 JgTransferNoticeServiceImpl jgTransferNoticeService,
                                 JgEquipTransferServiceImpl jgEquipTransferService,
                                 JgChangeRegistrationTransferServiceImpl changeRegistrationTransferService,
                                 JgChangeRegistrationReformServiceImpl changeRegistrationReformService,
                                 JgChangeRegistrationUnitServiceImpl changeRegistrationUnitService,
                                 JgEnableDisableServiceImpl jgEnableDisableService,
                                 JgMaintenanceContractServiceImpl maintenanceContractService,
                                 JgScrapCancelServiceImpl scrapCancelService,
                                 JgChangeRegistrationNameServiceImpl changeRegistrationNameService,
                                 ReportAnalysisServiceImpl reportAnalysisService,
                                 List<IEquipUsedCheck> equipUsedCheckList) {
        this.commonService = commonService;

        this.useRegistrationService = useRegistrationService;

        this.installationNoticeService = installationNoticeService;

        this.jgMaintainNoticeService = jgMaintainNoticeService;

        this.jgReformNoticeService = jgReformNoticeService;

        this.jgTransferNoticeService = jgTransferNoticeService;

        this.jgEquipTransferService = jgEquipTransferService;

        this.changeRegistrationTransferService = changeRegistrationTransferService;

        this.changeRegistrationReformService = changeRegistrationReformService;

        this.changeRegistrationUnitService = changeRegistrationUnitService;

        this.jgEnableDisableService = jgEnableDisableService;

        this.maintenanceContractService = maintenanceContractService;

        this.scrapCancelService = scrapCancelService;

        this.changeRegistrationNameService = changeRegistrationNameService;

        this.reportAnalysisService = reportAnalysisService;

        this.equipUsedCheckList = equipUsedCheckList;
    }


    @Override
    public void run(ApplicationArguments args) {
        // TODO 增加删除启动时， 完成时
        // 使用登记数据初始化
        List<JgUseRegistration> jgUseRegistrations = useRegistrationService.list(new LambdaQueryWrapper<JgUseRegistration>().ne(JgUseRegistration::getStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgUseRegistrations.forEach(jgUseRegistration -> {
            commonService.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), useRegistrationService.buildInstanceRuntimeData(jgUseRegistration));
        });

        // 安装告知数据初始化
        List<JgInstallationNotice> jgInstallationNotices = installationNoticeService.list(new LambdaQueryWrapper<JgInstallationNotice>().ne(JgInstallationNotice::getNoticeStatus, FlowStatusEnum.TO_BE_FINISHED.getCode()));
        jgInstallationNotices.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), installationNoticeService.buildInstanceRuntimeData(jgInstallation));
        });

        // 维修告知数据初始化
        List<JgMaintainNotice> jgMaintainNotices = jgMaintainNoticeService.list(new LambdaQueryWrapper<JgMaintainNotice>().ne(JgMaintainNotice::getNoticeStatus, FlowStatusEnum.TO_BE_FINISHED.getCode()));
        jgMaintainNotices.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), jgMaintainNoticeService.buildInstanceRuntimeData(jgInstallation));
        });

        // 改造告知数据初始化
        List<JgReformNotice> jgReformNotices = jgReformNoticeService.list(new LambdaQueryWrapper<JgReformNotice>().ne(JgReformNotice::getNoticeStatus, FlowStatusEnum.TO_BE_FINISHED.getCode()));
        jgReformNotices.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), jgReformNoticeService.buildInstanceRuntimeData(jgInstallation));
        });

        // 移装告知数据初始化
        List<JgTransferNotice> jgTransferNotices = jgTransferNoticeService.list(new LambdaQueryWrapper<JgTransferNotice>().ne(JgTransferNotice::getNoticeStatus, FlowStatusEnum.TO_BE_FINISHED.getCode()));
        jgTransferNotices.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), jgTransferNoticeService.buildInstanceRuntimeData(jgInstallation));
        });

        // 设备移交数据初始化
        List<JgEquipTransfer> jgEquipTransfers = jgEquipTransferService.list(new LambdaQueryWrapper<JgEquipTransfer>().ne(JgEquipTransfer::getApplyStatus, FlowStatusEnum.TO_BE_FINISHED.getCode()));
        jgEquipTransfers.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), jgEquipTransferService.buildInstanceRuntimeData(jgInstallation));
        });

        // 移转变更登记数据初始化
        List<JgChangeRegistrationTransfer> jgChangeRegistrationTransfers = changeRegistrationTransferService.list(new LambdaQueryWrapper<JgChangeRegistrationTransfer>().ne(JgChangeRegistrationTransfer::getAuditStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgChangeRegistrationTransfers.forEach(jgChangeRegistrationTransfer -> {
            commonService.saveExecuteFlowData2Redis(jgChangeRegistrationTransfer.getInstanceId(), changeRegistrationTransferService.buildInstanceRuntimeData(jgChangeRegistrationTransfer));
        });

        // 改造变更登记数据初始化
        List<JgChangeRegistrationReform> jgChangeRegistrationReforms = changeRegistrationReformService.list(new LambdaQueryWrapper<JgChangeRegistrationReform>().ne(JgChangeRegistrationReform::getAuditStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgChangeRegistrationReforms.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), changeRegistrationReformService.buildInstanceRuntimeData(jgInstallation));
        });

        // 单位变更登记数据初始化
        List<JgChangeRegistrationUnit> jgChangeRegistrationUnits = changeRegistrationUnitService.list(new LambdaQueryWrapper<JgChangeRegistrationUnit>().ne(JgChangeRegistrationUnit::getStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgChangeRegistrationUnits.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), changeRegistrationUnitService.buildInstanceRuntimeData(jgInstallation));
        });

        // 启用停用登记数据初始化
        List<JgEnableDisable> jgEnableDisables = jgEnableDisableService.list(new LambdaQueryWrapper<JgEnableDisable>().ne(JgEnableDisable::getAuditStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgEnableDisables.forEach(jgEnableDisable -> {
            commonService.saveExecuteFlowData2Redis(jgEnableDisable.getInstanceId(), jgEnableDisableService.buildInstanceRuntimeData(jgEnableDisable));
        });

        // 维保备案登记数据初始化
        List<JgMaintenanceContract> jgMaintenanceContracts = maintenanceContractService.list(new LambdaQueryWrapper<JgMaintenanceContract>().ne(JgMaintenanceContract::getStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgMaintenanceContracts.forEach(jgInstallation -> {
            commonService.saveExecuteFlowData2Redis(jgInstallation.getInstanceId(), maintenanceContractService.buildInstanceRuntimeData(jgInstallation));
        });

        // 注销报废登记数据初始化
        List<JgScrapCancel> jgScrapCancels = scrapCancelService.list(new LambdaQueryWrapper<JgScrapCancel>().ne(JgScrapCancel::getAuditStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgScrapCancels.forEach(jgScrapCancel -> {
            commonService.saveExecuteFlowData2Redis(jgScrapCancel.getInstanceId(), scrapCancelService.buildInstanceRuntimeData(jgScrapCancel));
        });

        // 单位名称变更数据初始化
        List<JgChangeRegistrationName> jgChangeRegistrationNames = changeRegistrationNameService.list(new LambdaQueryWrapper<JgChangeRegistrationName>().ne(JgChangeRegistrationName::getAuditStatus, FlowStatusEnum.TO_BE_FINISHED.getName()));
        jgChangeRegistrationNames.forEach(registrationName -> {
            commonService.saveExecuteFlowData2Redis(registrationName.getInstanceId(), changeRegistrationNameService.buildInstanceRuntimeData(registrationName));
        });

        // 统计接收机构树 根节点缓存预热
        reportAnalysisService.initRootOrgReceiveTree2Redis();

        // 流程中的设备统计数据预热
        equipUsedCheckList.forEach(IEquipUsedCheck::init);
    }
}
