package com.yeejoin.amos.boot.module.tcm.flc.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.BaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsBaseInstitutionDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

/**
 * 单位注册信息表
 *
 * @author system_generator
 * @date 2022-08-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "RegUnitInfoDto", description = "单位注册信息表")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RegUnitInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位名称")
    private String name;

    @ApiModelProperty(value = "证件code")
    private String unitCode;

    @ApiModelProperty(value = "证件类型")
    private String unitCodeType;

    @ApiModelProperty(value = "证件类型名称")
    private String unitCodeTypeName;

    @ApiModelProperty(value = "单位类型")
    private List<String> unitTypeList;

    @ApiModelProperty(value = "单位类型code")
    private List<String> unitTypeCodeList;

    @ApiModelProperty(value = "管辖机构")
    private String managementUnit;

    @ApiModelProperty(value = "管辖单位id")
    private String managementUnitId;

    @ApiModelProperty(value = "管辖单位编码")
    private String managementUnitCompanyCode;

    @ApiModelProperty(value = "管辖单位orgCode")
    private String managementUnitOrgCode;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "县区")
    private String district;

    @ApiModelProperty(value = "街道")
    private String stree;

    @ApiModelProperty(value = "小区")
    private String community;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;


    @ApiModelProperty(value = "单位法人")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonTel;

    @ApiModelProperty(value = "单位联系人")
    private String contactPerson;

    @ApiModelProperty(value = "联系人电话")
    private String contactPersonTel;

    @ApiModelProperty(value = "管理员姓名")
    private String adminName;

    @ApiModelProperty(value = "管理员用户名")
    private String adminLoginName;

    @ApiModelProperty(value = "管理员密码")
    private String adminLoginPwd;

    @ApiModelProperty(value = "管理员手机号")
    private String adminTel;

    @ApiModelProperty(value = "管理员身份证号")
    private String adminIdNumber;

    @ApiModelProperty(value = "身份证照片（正反面）")
    private List adminIdCardPhoto;

    @ApiModelProperty(value = "审核状态：1-无需审核；2-待审核；3-已审核")
    private String state;

    @ApiModelProperty(value = "工商信息")
    private RegUnitIcDto regUnitIc;

    @ApiModelProperty(value = "事业单位信息")
    private TzsBaseInstitutionDto regUnitMessage;

    @ApiModelProperty(value = "行政许可")
    private List<BaseUnitLicenceDto> unitLicences = new ArrayList<>();

    @ApiModelProperty(value = "平台公司id,平台创建公司后更新")
    private String amosCompanySeq;


    @ApiModelProperty(value = "平台用户id,平台创建用户后更新")
    private String adminUserId;

    JSONObject form;

    @ApiModelProperty(value = "注册类型")
    private String registerType;

    @ApiModelProperty(value = "单位所在地是否为全国")
    private String isNationwide;

    /**
     * 气站对接appId
     */
    private String appId;
}
