package com.yeejoin.amos.boot.module.jyjc.api.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class JyjcOpeningApplicationRequestDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位编码")
    private String unitCode;

    @ApiModelProperty(value = "单位编码Name")
    private String unitCodeName;

    @ApiModelProperty(value = "检测区域名称（冗余）")
    private String detectionRegionName;

    @ApiModelProperty(value = "申请单号")
    private String applicationSeq;

    @ApiModelProperty(value = "检验结果方式")
    private String resultType;

    @ApiModelProperty(value = "有效期至")
    private String expiryDate;

    @ApiModelProperty(value = "受理日期（接收日期）")
    private String acceptDate;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "状态Name")
    private String statusName;

    @ApiModelProperty(value = "申请时间")
    private String applyTime;

    @ApiModelProperty(value = "supervision: 监管; enterprise: 企业")
    private String type;

    @ApiModelProperty("开通业务类型")
    private String openBizType;

    @ApiModelProperty("身份信息对应的开通业务类型")
    private String openBizTypeIdentify;
}
