package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.dto.EquipmentInfoDto;
import com.yeejoin.amos.api.openapi.face.model.EnterpriseInfoModel;
import com.yeejoin.amos.api.openapi.face.model.InspectionDetectionInfoModel;
import com.yeejoin.amos.api.openapi.face.model.InspectionInfoModel;
import com.yeejoin.amos.api.openapi.face.model.ProduceInfoModel;
import com.yeejoin.amos.api.openapi.face.model.RegistrationInfoModel;
import com.yeejoin.amos.api.openapi.face.model.StaffQualifInfoModel;
import com.yeejoin.amos.api.openapi.face.model.UnitLicenceModel;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidConstructionInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.DesignInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.EnclosureInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidMaintenanceInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipOtherInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidStaffBaseInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MiddEquipSuperviseInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MiddEquipUseInfo;
import com.yeejoin.amos.api.openapi.face.service.ConstructionInfoService;
import com.yeejoin.amos.api.openapi.face.service.CreateCodeService;
import com.yeejoin.amos.api.openapi.face.service.DesignInfoService;
import com.yeejoin.amos.api.openapi.face.service.EnclosureInfoService;
import com.yeejoin.amos.api.openapi.face.service.EnterpriseInfoService;
import com.yeejoin.amos.api.openapi.face.service.InspectionInfoService;
import com.yeejoin.amos.api.openapi.face.service.MaintenanceInfoService;
import com.yeejoin.amos.api.openapi.face.service.OtherInfoService;
import com.yeejoin.amos.api.openapi.face.service.ProduceInfoService;
import com.yeejoin.amos.api.openapi.face.service.RegistrationInfoService;
import com.yeejoin.amos.api.openapi.face.service.StaffBaseInfoService;
import com.yeejoin.amos.api.openapi.face.service.StaffQualifInfoService;
import com.yeejoin.amos.api.openapi.face.service.SuperviseInfoService;
import com.yeejoin.amos.api.openapi.face.service.TechInfoService;
import com.yeejoin.amos.api.openapi.face.service.UnitLicenceService;
import com.yeejoin.amos.api.openapi.face.service.UseInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;

/**
 * 监管业务数据对接
 *
 * @author Zhang Yingbin
 */
@RestController
@RequestMapping(value = "/supervision")
@Api(tags = "Supervise-监管业务数据接入")
public class SuperviseController {

    @Autowired
    private DesignInfoService designInfoService;

    @Autowired
    private ProduceInfoService produceInfoService;

    @Autowired
    private ConstructionInfoService constructionInfoService;

    @Autowired
    private RegistrationInfoService registrationInfoService;

    @Autowired
    private UseInfoService useInfoService;

    @Autowired
    private MaintenanceInfoService maintenanceInfoService;

    @Autowired
    private SuperviseInfoService superviseInfoService;

    @Autowired
    private OtherInfoService otherInfoService;

//    @Autowired
//    private ElevatorTechInfoService evatorTechInfoService;

    @Autowired
    private EnclosureInfoService enclosureInfoService;

    @Autowired
    private EnterpriseInfoService enterpriseInfoService;

    @Autowired
    private StaffBaseInfoService staffBaseInfoService;

    @Autowired
    private StaffQualifInfoService staffQualifInfoService;

    @Autowired
    private InspectionInfoService inspectionInfoService;

    @Autowired
    private UnitLicenceService unitLicenceService;

    @Autowired
    private TechInfoService techInfoService;

    @Autowired
    private CreateCodeService createCodeService;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增设计信息")
    @PostMapping(value = "/designInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveDesignInfo(@RequestBody List<DesignInfo> designInfo) throws Exception {
        return ResponseHelper.buildResponse(designInfoService.saveDesignInfo(designInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增制造信息")
    @PostMapping(value = "/produceInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveProduceInfo(@RequestBody List<ProduceInfoModel> produceInfo) throws Exception {
        return ResponseHelper.buildResponse(produceInfoService.saveProduceInfo(produceInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增施工信息")
    @PostMapping(value = "/constructionInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveConstructionInfo(@RequestBody List<MidConstructionInfo> constructionInfoList) {
        if (ValidationUtil.isEmpty(constructionInfoList)) {
            throw new BadRequest("上送数据为空");
        }
        return ResponseHelper.buildResponse(constructionInfoService.saveConstructionInfo(constructionInfoList.get(0)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增注册等级信息")
    @PostMapping(value = "/registrationInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveRegistrationInfo(@RequestBody List<RegistrationInfoModel> registrationInfo) throws Exception {
        return ResponseHelper.buildResponse(registrationInfoService.saveRegistrationInfo(registrationInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增使用信息")
    @PostMapping(value = "/useInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveUseInfo(@RequestBody List<MiddEquipUseInfo> useInfo) throws Exception {
        return ResponseHelper.buildResponse(useInfoService.saveUseInfo(useInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增维保单位信息")
    @PostMapping(value = "/maintenanceInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveMaintenanceInfo(@RequestBody List<MidMaintenanceInfo> maintenanceInfoList) {
        if (ValidationUtil.isEmpty(maintenanceInfoList)) {
            throw new BadRequest("上送数据为空");
        }
        return ResponseHelper.buildResponse(maintenanceInfoService.saveMaintenanceInfo(maintenanceInfoList.get(0)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增监督管理信息")
    @PostMapping(value = "/superviseInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveSuperviseInfo(@RequestBody List<MiddEquipSuperviseInfo> superviseInfo) throws Exception {
        return ResponseHelper.buildResponse(superviseInfoService.saveSuperviseInfo(superviseInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增其他信息")
    @PostMapping(value = "/otherInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveOtherInfo(@RequestBody List<MidEquipOtherInfo> otherInfo) throws Exception {
        return ResponseHelper.buildResponse(otherInfoService.saveOtherInfo(otherInfo));
    }

//    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
//    @ApiOperation(value = "新增电梯技术参数")
//    @PostMapping(value = "/elevatorTechInfo")
//    @RestEventTrigger(value = "openapiLogEventHandler")
//    public ResponseModel<String> saveElevatorTechInfo(@RequestBody List<ElevatorTechInfoModel> elevatorTechInfo) throws Exception {
//        return ResponseHelper.buildResponse(evatorTechInfoService.saveElevatorTechInfo(elevatorTechInfo));
//    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增特种设备附件资料信息")
    @PostMapping(value = "/enclosureInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveEnclosureInfo(@RequestBody List<EnclosureInfo> enclosureInfo) throws Exception {
        return ResponseHelper.buildResponse(enclosureInfoService.saveEnclosureInfo(enclosureInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增企业数据信息")
    @PostMapping(value = "/enterpriseInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveEnterpriseInfo(@RequestBody List<EnterpriseInfoModel> enterpriseInfo) throws Exception {
        return ResponseHelper.buildResponse(enterpriseInfoService.saveEnterpriseInfo(enterpriseInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增人员基本信息")
    @PostMapping(value = "/staffBaseInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveStaffBaseInfo(@RequestBody List<MidStaffBaseInfo> staffBaseInfo) throws Exception {
        return ResponseHelper.buildResponse(staffBaseInfoService.saveStaffBaseInfo(staffBaseInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增人员资质信息")
    @PostMapping(value = "/staffQualifInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveStaffQualifInfo(@RequestBody List<StaffQualifInfoModel> staffQualifInfo) throws Exception {
        return ResponseHelper.buildResponse(staffQualifInfoService.saveStaffQualifInfo(staffQualifInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "特种设备检验信息")
    @PostMapping(value = "/inspectionInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveInspectionInfo(@RequestBody List<InspectionInfoModel> inspectionInfo) throws Exception {
        return ResponseHelper.buildResponse(inspectionInfoService.saveInspectionInfo(inspectionInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "查询许可信息")
    @GetMapping(value = "/licenceInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<List<UnitLicenceModel>> getLicenceInfo(@RequestParam String unitCode) {
        return ResponseHelper.buildResponse(unitLicenceService.getLicenceInfo(unitCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增特种设备附件资料信息")
    @PostMapping(value = "/techInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveTechInfo(@RequestBody List<JSONObject> techInfo) {
        return ResponseHelper.buildResponse(techInfoService.saveTechInfo(techInfo));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "赋码")
    @PostMapping(value = "/generation/code")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<Map<String, Object>> createCode(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(createCodeService.createCode(map));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "数据状态修改")
    @PostMapping(value = "/update/dateStatus")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<Object> updateStatus(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(createCodeService.updateStatus(map));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "检验检测信息")
    @GetMapping(value = "/inspectionInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<InspectionDetectionInfoModel> selectInspect(@RequestParam String superviseCode) {
        return ResponseHelper.buildResponse(inspectionInfoService.selectInspect(superviseCode));
    }

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "监管设备信息")
	@PostMapping(value = "/equipment/info")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> saveEquipmentInfo(@RequestBody EquipmentInfoDto equipmentInfoDto) {
        String supervisoryCode = equipmentInfoDto.getSupervisoryCode();
        if (ValidationUtil.isEmpty(supervisoryCode)) {
            throw new BadRequest("监管码信息不存在");
        }
		return ResponseHelper.buildResponse(useInfoService.saveEquipmentInfo(equipmentInfoDto));
	}

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getUnitLicenceMessage", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据统一信用代码查询许可信息", notes = "根据统一信用代码查询许可信息")
    public ResponseModel<Object> getUnitLicenceMessage(@RequestParam("unitCode") String unitCode) {
        return ResponseHelper.buildResponse(useInfoService.getUnitLicenceMessage(unitCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getBusinessInformation", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据统一信用代码查询工商信息", notes = "根据统一信用代码查询工商信息")
    public ResponseModel<Object> getBusinessInformation(@RequestParam("unitCode") String unitCode) {
        return ResponseHelper.buildResponse(useInfoService.getBusinessInformation(unitCode));
    }
}
