package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 使用登记状态西悉尼
 */
@Getter
@AllArgsConstructor
public enum CancelWorkFlowStatusEnum {

    SUBMIT("使用单位提交", "submit", "使用单位待提交", "一级单位已驳回", "使用单位撤回"),
    RECEIVE("一级受理", "receive", "一级单位待受理", "二级单位已驳回", "一级单位撤回"),
    PRELIMINARY("二级受理", "preliminary", "二级单位待受理", "三级单位已驳回", "二级单位撤回"),
    REEXAMINE("三级受理", "reexamine", "三级单位待受理", "", ""),
    COMPLETE("已完成", "complete", "已完成", "", "");




    private final String name;

    private final String code;

    private final String pass;

    private final String reject;

    private final String rollBack;



    public static CancelWorkFlowStatusEnum getMessage(String name){
        for (CancelWorkFlowStatusEnum constants : values()) {
            if (constants.getName().equals(name)) {
                return constants;
            }
        }
        return null;
    }

    public static CancelWorkFlowStatusEnum getMessageByCode(String code){
        for (CancelWorkFlowStatusEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants;
            }
        }
        return null;
    }
}
