package com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ZBGLImpl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.common.api.enums.IssueMainBodyEnum;
import com.yeejoin.amos.boot.module.common.api.enums.IssueTypeEnum;
import com.yeejoin.amos.boot.module.statistcs.biz.service.IZBGLService;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.mapper.ZBGLStatisticsMapper;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class DnztdwyhpmServiceImpl implements IZBGLService {
    @Resource
    private StCommonServiceImpl stCommonService;

    @Resource
    private ZBGLStatisticsMapper zbglStatisticsMapper;
    @Override
    public Map<String, Object> getChart(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        List<String> issueTypeList = IssueTypeEnum.getEnumCodeListByMainBody(IssueMainBodyEnum.COMPANY.getCode());
        List<Map<String,Object>> result =  regionModels.parallelStream().map(r -> {
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode()+"");
            DPFilterParamForDetailDto dpFilterParamForDetailDtoNew = new DPFilterParamForDetailDto();
            dpFilterParamForDetailDtoNew.setOrgCode(orgCode);
            Map<String, Object> itemResult = new HashMap<>();
            Map<String,Long> map = zbglStatisticsMapper.getDNZTDWYHPMChartData(dpFilterParamForDetailDtoNew,issueTypeList);
            if(map.get("allCount") != 0 && map.get("endCount") != 0){
                itemResult.put("rate",BigDecimal.valueOf(map.get("endCount")).divide(BigDecimal.valueOf(map.get("allCount")),2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }else{
                itemResult.put("rate","0");
            }
            itemResult.put("count",map.get("allCount"));
            itemResult.put("xdata",r.getRegionName());
            return itemResult;
        }).collect(Collectors.toList());

        Map<String,Object> returnMap = new HashMap<>();
        List<Map<String,Object>> legendData = new ArrayList<>();
        for(int i = 0;i<2; i++){
            Map<String,Object> map = new HashMap<>();
            if(i == 0){
                map.put("dataKey","count");
                map.put("value","隐患总数");
                map.put("chartType","bar");
            }else{
                map.put("dataKey","rate");
                map.put("value","完结率");
                map.put("chartType","line");
            }
            legendData.add(map);
        }
        returnMap.put("legendData",legendData);

        List xdata = new ArrayList();
        List count = new ArrayList();
        List rate = new ArrayList();
        Long sum = 0L;
        for(int i = 0;i<result.size();i++){
            sum = sum + (Long)result.get(i).get("count");
        }
        for(int i = 0;i<result.size();i++){
            xdata.add(result.get(i).get("xdata"));
            count.add(result.get(i).get("count") == null ? "0" : result.get(i).get("count")+"");
            rate.add(result.get(i).get("rate") == null ? "0" : result.get(i).get("rate")+"");
        }

        returnMap.put("xdata",xdata);
        returnMap.put("count",count);
        returnMap.put("rate",rate);

        return returnMap;
    }

    @Override
    public Page<Map<String, Object>> getPage(Page page,DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        String orgCode = stCommonService.getAndSetOrgCode(dpFilterParamForDetailDto.getCityCode());
        dpFilterParamForDetailDto.setOrgCode(orgCode);
        Page<Map<String,Object>> returnPage = zbglStatisticsMapper.getUnitByOrgCode(page,dpFilterParamForDetailDto);
        List<String> unitCodeList = new ArrayList<>();
        Map<String,Map<String,Object>> unitMap = new HashMap<>();
        for(int i = 0;i<returnPage.getRecords().size();i++){
            unitMap.put(returnPage.getRecords().get(i).get("principalUnitCode").toString(),new HashMap<>());
            unitCodeList.add(returnPage.getRecords().get(i).get("principalUnitCode").toString());
        }
        Map<String,Long> countMap = new HashMap<>();
        if(!CollectionUtil.isEmpty(unitCodeList)) {
            List<Map<String, Object>> list = zbglStatisticsMapper.getDNZTDWYHPMPageData(unitCodeList);
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> map = unitMap.get(list.get(i).get("principalUnitCode"));
                map.put(list.get(i).get("problemTypeCode") + "", list.get(i).get("count"));
                map.put("principalUnit", list.get(i).get("principalUnit"));
                map.put("principalUnitCode", list.get(i).get("principalUnitCode"));
                Long aLong = countMap.get(list.get(i).get("principalUnitCode"));
                if (aLong == null) {
                    countMap.put(list.get(i).get("principalUnitCode").toString(), (Long) list.get(i).get("count"));
                } else {
                    countMap.put(list.get(i).get("principalUnitCode").toString(), aLong + (Long) list.get(i).get("count"));
                }
            }
            List<Map<String, Object>> resultList = new ArrayList();
            unitMap.entrySet().forEach(item -> {
                Map<String, Object> value = item.getValue();
                value.entrySet().forEach(t -> {
                    if (!t.getKey().equals("principalUnit") && !t.getKey().equals("principalUnitCode")) {
                        t.setValue(t.getValue() + " / " + new BigDecimal(t.getValue() + "").divide(BigDecimal.valueOf(countMap.get(item.getValue().get("principalUnitCode"))), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100)).stripTrailingZeros().toPlainString() + "%");
                    }
                });
                resultList.add(value);
            });
            page.setRecords(resultList);
        }
        return page;
    }

    @Override
    public List<Map<String, String>> getTitle(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<Map<String, String>> list = IssueTypeEnum.getEnumListByMainBody(IssueMainBodyEnum.COMPANY.getCode());
        List<Map<String,String>> returnList = new ArrayList();
        for(int i = 0;i<list.size();i++){
            Map<String,String> map = new HashMap<>();
            map.put("dataIndex",list.get(i).get("code"));
            map.put("title",list.get(i).get("name"));
            returnList.add(map);
        }
        Map<String,String> map = new HashMap<>();
        map.put("dataIndex","principalUnit");
        map.put("title","主体名称");
        returnList.add(0,map);
        Map<String,String> map1 = new HashMap<>();
        map1.put("dataIndex","principalUnitCode");
        map1.put("title","主体编码");
        returnList.add(1,map1);
        return returnList;
    }
}
