package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PersonnelBusinessServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.PersonnelBusinessDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 人员业务信息表
 *
 * @author system_generator
 * @date 2023-09-01
 */
@RestController
@Api(tags = "人员业务信息表Api")
@RequestMapping(value = "/personnel-business")
public class PersonnelBusinessController extends BaseController {

    @Autowired
    PersonnelBusinessServiceImpl personnelBusinessServiceImpl;

    /**
     * 新增人员业务信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增人员业务信息表", notes = "新增人员业务信息表")
	public ResponseModel<PersonnelBusinessDto> save(@RequestBody PersonnelBusinessDto model) {
	    model = personnelBusinessServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新人员业务信息表", notes = "根据sequenceNbr更新人员业务信息表")
	public ResponseModel<PersonnelBusinessDto> updateBySequenceNbrPersonnelBusiness(@RequestBody PersonnelBusinessDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(personnelBusinessServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除人员业务信息表", notes = "根据sequenceNbr删除人员业务信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(personnelBusinessServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个人员业务信息表",  notes = "根据sequenceNbr查询单个人员业务信息表")
	public ResponseModel<PersonnelBusinessDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(personnelBusinessServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "人员业务信息表分页查询",  notes = "人员业务信息表分页查询")
	public ResponseModel<Page<PersonnelBusinessDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<PersonnelBusinessDto> page = new Page<PersonnelBusinessDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(personnelBusinessServiceImpl.queryForPersonnelBusinessPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "人员业务信息表列表全部数据查询",   notes = "人员业务信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PersonnelBusinessDto>> selectForList() {
	    return ResponseHelper.buildResponse(personnelBusinessServiceImpl.queryForPersonnelBusinessList());
	}
}
