package com.yeejoin.amos.boot.module.jxiop.biz.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IMapRegionService;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.*;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.Test;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitoringServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.RegionServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.TestServiceImpl;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javafx.scene.control.Tab;
import org.aspectj.apache.bcel.classfile.Module;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;

@RestController
@Api(tags = "监盘地图接口")
@RequestMapping(value = "/monitormap")
public class MonitoringMapController extends BaseController {
    @Value("${sec.startdate:2017-06-30}")
    String secStartDate;

    @Autowired
    MonitoringServiceImpl monitoringServiceImpl;
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "获取监盘全国-安全生产天数")
    @GetMapping("/getSecDays")
    public ResponseModel<HashMap<String,String>> getSecDays(@RequestParam (value = "provinceName", required = false)String provinceName,@RequestParam (value = "type", required = false)String type) {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getSecDays(secStartDate));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "获取监盘全国地图数据")
    @GetMapping("/nationwide")
    public ResponseModel<List<RegionNationWideDto>> getNationWideInfo(@RequestParam (value = "provinceName", required = false)String provinceName,@RequestParam (value = "type", required = false)String type) {
      return ResponseHelper.buildResponse(monitoringServiceImpl.getNationWideInfo(provinceName,type));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "获取监盘全国地图-发电量数据")
    @GetMapping("/getNationalPowerGenerationData")
    public ResponseModel<List<HashMap<String,Object>>> getNationalPowerGenerationData() {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getNationalPowerGenerationData());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "获取监盘全国地图-获取功率曲线下拉框数据")
    @GetMapping("/getSelectDataForNational")
    public ResponseModel<List<HashMap<String,Object>>> getSelectDataForNational() {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getSelectDataForNational());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "获取区域电量指标完成情况")
    @GetMapping("/getCompletionOfPowerIndicatorsByProvinceName")
    public ResponseModel<ResultsData> getCompletionOfPowerIndicatorsByProvinceName(@RequestParam(required = true) int current, @RequestParam(required = true) int size, @RequestParam(required = true) String provinceName) {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getCompletionOfPowerIndicatorsByProvinceName(current,size,provinceName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "根据场站id动态获取tab页签")
    @GetMapping("/getTabsByStationBasicId")
    public ResponseModel<List<TabDto>> getTabsByStationBasicId(@RequestParam(required = true) String stationBasicId) {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getTabsByStationBasicId(stationBasicId));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页地图-全国")
    @GetMapping("/getAreaInfo")
    public ResponseModel<List<MapAreaInfoDto>> getAreaInfo() {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getAreaInfo());
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页地图-片区")
    @GetMapping("/getStaitonListInfoByAreaName")
    public ResponseModel<List<HomeMapStationInfoDto>> getStaitonListInfoByAreaName(@RequestParam(required = true)String areaName) {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getStaitonListInfoByAreaName(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-场站分类信息")
    @GetMapping("/getStaionCategoryInfo")
    public ResponseModel<List<Map<String,String>>> getStaionCategoryInfo(@RequestParam(required = false)String areaName) {
    return  ResponseHelper.buildResponse(monitoringServiceImpl.getStaionCategoryInfo(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-装机容量")
    @GetMapping("/getInstallCapityByAreaName")
    public ResponseModel<HashMap<String,String>> getInstallCapityByAreaName(@RequestParam(required = false)String areaName) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getInstallCapityByAreaName(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-有功功率")
    @GetMapping("/getActivePowerByAreaName")
    public ResponseModel<HashMap<String,String>> getActivePowerByAreaName(@RequestParam(required = false)String areaName) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getActivePowerByAreaName(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-社会贡献")
    @GetMapping("/getSocialContributionDtoList")
    public ResponseModel<Page<SocialContributionDto>> getSocialContributionDtoList(@RequestParam(required = false)String areaName, @RequestParam(required = false)String station) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getSocialContributionDtoList(areaName,station));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-发电量趋势")
    @GetMapping("/getPowerGenerationTrendsOfMonth")
    public ResponseModel<HashMap<String, List<String>>> getPowerGenerationTrendsOfMonth(@RequestParam(required = false)String areaName) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getPowerGenerationTrendsOfMonth(areaName));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-发电量详情")
    @GetMapping("/getDetailsOnPowergeneration")
    public ResponseModel<Page<HashMap<String,String>>> getDetailsOnPowergeneration(@RequestParam(required = false)String areaName) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getDetailsOnPowergeneration(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-发电量趋势完成率")
    @GetMapping("/getPowerGenerationTrendsOfCompletionRate")
    public ResponseModel<HashMap<String, List<String>>> getPowerGenerationTrendsOfCompletionRate(@RequestParam(required = false)String areaName) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getPowerGenerationTrendsOfCompletionRate(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-发电top5")
    @GetMapping("/getPowerGenerationTrendsOfCompletionTopFive")
    public ResponseModel<Page<HashMap<String,String>>> getPowerGenerationTrendsOfCompletionTopFive(@RequestParam(required = false)String areaName) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getPowerGenerationTrendsOfCompletionTopFive(areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "监盘首页-发电小时排名top3")
    @GetMapping("/getPowerGenerationTrendsOfCompletionTopThree")
    public ResponseModel<Page<HashMap<String, String>>> getPowerGenerationTrendsOfCompletionTopThree(@RequestParam(required = false)String areaName,@RequestParam(required = false,defaultValue = "0")String tabValue) {
        return  ResponseHelper.buildResponse(monitoringServiceImpl.getPowerGenerationTrendsOfCompletionTopThree(tabValue,areaName));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "运行监盘-获取全国数据")
    @GetMapping("/getTotalData")
    public void getTotalData() {
          monitoringServiceImpl.getTotalData();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(value = "运行监盘-功率曲线")
    @GetMapping("/getTheStationPowerCurve")
    public ResponseModel<HashMap<String, Object>> getTheStationPowerCurve(@RequestParam(required = false)String stationId,@RequestParam(required = false)String date) {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getTheStationPowerCurve(stationId,date));
    }
}
