package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.vo.FileUploadVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.context.annotation.Configuration;

import java.util.Date;
import java.util.List;

/**
 * @author zjw
 * @date 2020-09-04
 */
@Data
@Accessors(chain = true)
@TableName("f_fire_fighting_system")
@ApiModel(value = "f_fire_fighting_system", description = "")
@Configuration
public class FireFightingSystemEntity {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "编号")
    private String code;

    @ApiModelProperty(value = "系统类别 ")
    private String systemType;

    @ApiModelProperty(value = "系统分类id")
    private Long formGroupId;

    @ApiModelProperty(value = "安装日期 ")
    private Date installDate;

    @ApiModelProperty(value = "负责人 ")
    private String chargePerson;

    @ApiModelProperty(value = "负责人姓名")
    private String chargePersonName;

    @ApiModelProperty(value = "负责人电话 ")
    private String chargePersonPhone;

    @ApiModelProperty(value = "施工单位 ")
    private String constructionUnit;

    @ApiModelProperty(value = "维保单位 ")
    private String maintenanceUnit;

    @ApiModelProperty(value = "维保电话 ")
    private String maintenancePhone;

    @ApiModelProperty(value = "维保频率 ")
    private String maintenanceFrequency;

    @ApiModelProperty(value = "首次维保日期 ")
    private Date firstMaintenanceDate;

    @ApiModelProperty(value = "最后更新者的id ")
    private String recUserId;

    @ApiModelProperty(value = "更新时间 ")
    private Date recDate;

    @ApiModelProperty(value = "备注 ")
    private String remark;

    @ApiModelProperty(value = "code ")
    private String orgCode;

    @ApiModelProperty(value = "排序 ")
    private String sort;

    @ApiModelProperty(value = "画布id ")
    private Long sceneId;


    @ApiModelProperty(value = "控制柜所在建筑 ")
    private String controBoxBuild;

    @ApiModelProperty(value = "保护对象 ")
    private String proObject;

    @ApiModelProperty(value = "产品编码 ")
    private String proCode;

    @ApiModelProperty(value = "生产厂家 ")
    private String factory;

    @ApiModelProperty(value = "动态表单实例id")
    private Long instanceId;

    @ApiModelProperty(value = "控制柜安装位置 ")
    private String controBoxAddress;

    @ApiModelProperty(value = "核心部件Ids ")
    private String coreComponentIds;

    @ApiModelProperty("组态获取系统详情接口地址")
    @TableField(exist = false)
    private String detailPaneApi;

    @ApiModelProperty("组态获取分页接口地址")
    @TableField(exist = false)
    private String detailListPaneApi;

    @TableField(exist = false)
    List<FileUploadVo> systemimg;

    @ApiModelProperty("系统类型编码")
    private String systemTypeCode;


    @ApiModelProperty("机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty("机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "分析报告统计用参数（为空不统计） ")
    private String analysisIndexKey;

    @ApiModelProperty(value = "责任单位")
    private String designOrg;

    @ApiModelProperty(value = "主要设计人员")
    private String leadDesigner;
}
