package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 薪资确认任务表
 *
 * @author duanwei
 * @date 2020-12-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_salary_confirm")
@ApiModel(value="TaskSalaryConfirm对象", description="薪资确认任务表")
public class TaskSalaryConfirm extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "分包商id")
    private Long companyId;

    @ApiModelProperty(value = "合同工资总额")
    private BigDecimal contractTotalSalary;

    @ApiModelProperty(value = "本次发放金额")
    private BigDecimal currentPaySalary;

    @ApiModelProperty(value = "付款批次")
    private String payBatch;

    @ApiModelProperty(value = "银行账户")
    private String bankAccount;

    @ApiModelProperty(value = "付款开始时间")
    private Date payStartTime;

    @ApiModelProperty(value = "付款结束时间")
    private Date payEndTime;

    @ApiModelProperty(value = "发放类型")
    private String payType;

    @ApiModelProperty(value = "发放日期")
    private Date payDate;

    @ApiModelProperty(value = "本次发放比例")
    private Integer payRatio;


}
