package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.MonitorEvent;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmLogMapper;
import com.yeejoin.equipmanage.service.IConfirmAlarmService;
import com.yeejoin.equipmanage.service.impl.MonitorEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author zjw
 */

@RestController
@Api(tags = "警情确认Api")
@RequestMapping(value = "/confirmAlarm", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ConfirmAlarmController extends AbstractBaseController {

    @Autowired
    @Lazy
    IConfirmAlarmService iConfirmAlarmService;
    @Autowired
    EquipmentSpecificAlarmLogMapper equipmentSpecificAlarmLogMapper;
    @Autowired
    private MonitorEventService monitorEventService;

    @GetMapping(value = "/getDetailsById")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据id，type查询确警页面相关数据")
    public Map<String, Object> getDetailsById(@RequestParam Long alamId, @RequestParam(required = false) Long equipId, @RequestParam(required = false) String type, @RequestParam String area) {
        return iConfirmAlarmService.getDetailsById(alamId, equipId, type, area);
    }

    @PostMapping(value = "/confirmAlam")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "保存")
    public void confirmAlam(@RequestBody EquipmentSpecificAlarmLog ent) {
        String appKey = getAppKey();
        String product = getProduct();
        iConfirmAlarmService.confirmAlam(ent, appKey, product, getToken(), getUserId());
    }

    @PostMapping(value = "/addConfirmAlam")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "警情确认保存")
    public void addConfirmAlam(@RequestBody EquipmentSpecificAlarmLog ent) {
        String appKey = getAppKey();
        String product = getProduct();
        String token = getToken();
        iConfirmAlarmService.confirmAlam(ent, appKey, product, getToken(), getUserId());
    }

    @GetMapping(value = "/getFireAlarm")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "未处理消防告警")
    public Map<String, Object> getFireAlarm() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("FireAlarmNum", iConfirmAlarmService.getFireAlarm().intValue());
        return map;
    }

    @GetMapping(value = "/getFaultAlarm")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "未处理故障告警")
    public Map<String, Object> getFaultAlarm() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("FaultAlarmNum", iConfirmAlarmService.getFaultAlarm().intValue());
        return map;
    }

    @GetMapping(value = "/getMonitorEvent")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "未处理物联告警")
    public Map<String, Object> getMonitorEvent() {
        Map<String, Object> map = new LinkedHashMap<>();
        LambdaQueryWrapper<MonitorEvent> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MonitorEvent::getEventState, "未处理");
        int monitorEventNum = monitorEventService.getBaseMapper().selectCount(queryWrapper);
        map.put("monitorEventNum", monitorEventNum);
        return map;
    }


    @GetMapping(value = "/{equipmentSpecificId}/relation")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询设备画布及关联摄像头信息")
    public Map<String, Object> getEquipSceneAndRelationVideo(@PathVariable Long equipmentSpecificId) {
        return iConfirmAlarmService.getEquipSceneAndRelationVideo(equipmentSpecificId);
    }
}
