package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.FormInstance;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.dto.BuildIsRiskDTO;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoListVO;
import org.apache.ibatis.annotations.Param;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;


/**
 * 分组字段表
 * @author DELL
 */
public interface FormInstanceMapper extends BaseMapper<FormInstance> {
    /**
     * 实例基本信息分页查询
     * @param page 分页信息
     * @param params 查询条件
     * @param fieldNames 字段
     * @return List<Map<String,Object>>
     */
    Page<Map<String,Object>> queryInstancePage(Page page,
                                               @Param("groupCode") String groupCode,
                                               @Param("fieldNames") Map<String,Object> fieldNames,
                                               @Param("params") Map<String,String> params
    );
    /**
     * 不分页查询
     * @param groupCode 分组编号
     * @param fieldNames 字段
     * @param params 查询参数
     * @return List<Map<String, Object>>
     */
    List<Map<String, Object>> queryForMapList(@Param("groupCode") String groupCode,
                                              @Param("fieldNames") Map<String, Object> fieldNames,
                                              @Param("params") Map<String, String> params);

    /**
     * 查询指定节点的子
     * @param parentId
     * @return
     */
    List<Map<String,Object>> querySpecialChildrenList(String parentId, String bizOrgCode);

    /**
     * 查询指定节点的子
     * @param parentId
     * @return
     */
    List<Map<String,Object>> querySpecialChildrenListByBizOrgCode(@Param("parentId") String parentId, @Param("bizOrgCode") String bizOrgCode);

    /**
     * @Description 分页查询
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page queryPage(Page page, @Param("query") BuildSearchDTO dto);
    /**
     * @Description 不分页
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    List<Map<String,Object>> queryPage(@Param("query") BuildSearchDTO dto);
    /**
     * @Description 分页查询
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page roomPage(Page page, @Param("query") BuildSearchDTO dto);
    /**
     * @Description 查询列表
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    List<Map<String,Object>> roomPage(@Param("query") BuildSearchDTO dto);
    /**
     * @Description 根据parentId查询其下资源（楼层、房间）
     * @param instanceId
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 15:06
     */
    List<Map<String,Object>> queryFloorRoom(List<Long> instanceId);

    /**
     * 根据instanceId、groupType，获取建筑楼层list
     * @param dto
     * @return
     */
    List<BuildSearchDTO> getBuildFloorList(@Param("query") BuildSearchDTO dto);

    /**
     * 根据instanceId，获取建筑楼层信息
     * @param instanceId
     * @param fileCategory
     * @return
     */
    LinkedHashMap<String, Object> findByInstanceId(@Param("instanceId") Long instanceId, @Param("fileCategory") String fileCategory);

    List<LinkedHashMap<String, Object>> findDetailByInstanceId(@Param("instanceId") Long instanceId, @Param("fileCategory") String fileCategory);

    /**
     * 消防建筑视屏监控统计树
     * @return
     * @param bizOrgCodeList
     */
    List<Map<String, Object>> getBuildVideoListCount(@Param("list") List<String> bizOrgCodeList);

    /**
     * 可乐建筑视屏监控统计树
     * @return
     */
    List<Map<String, Object>> getColaBuildVideoListCount(@Param("dto") BuildingVideoListVO dto);

    /**
     * 同步仓库
     * @param formKeyMap
     * @return
     */
    int saveStucture(Map<String, Object> formKeyMap);

    Map<String, String> getChildListdate(@Param("id")Long id);

    void updateListChild(@Param("value")String value,
                          @Param("ids") List<String> ids,
                          @Param("fieldName") String fieldName);


    /**
     * 获取仓库父类详细位置
     * @param id
     * @return
     */
    String getStuctureName(String id);
    String getStuName(String id);
    Long getStructureParentId(String id);
    /**
     * 删除仓库
     * @param id
     * @return
     */
    int deleteStuById(Long  id);

    /**
     * 修改仓库
     */
    int updateStr(@Param("id") Long  id,@Param("name") String name,@Param("fullName") String fullName,@Param("parentId")String parentId, @Param("code")String code, @Param("bizOrgCode")String bizOrgCode,@Param("bizOrgName")String bizOrgName);


    /**
     * 修改仓库
     */
    int updateStrFullName(@Param("id") Long  id,@Param("name") String name,@Param("fullName") String fullName);

    /**
     * 查询未设置风险区域的子风险区域列表
     * @param instanceId
     * @return
     */
    List<BuildIsRiskDTO> getChildrenNotIsRiskList(@Param("instanceId") String instanceId);


    int clearSystemId(@Param("id")  Long id );

    /**
     * 清除绑定关系
     * @param instanceId 建筑实例id
     */
    void clearRegionBind(Long instanceId);

    /*
    * 查询id下是否还有子类货位信息
    * */
    List<Map<String,Object>> getParentId(Long parentId);

    Map<String, String> getIdAndType(String  id);

    Map<String, Object>  getFormInstanceById(Long instanceId);

    /**
     * 获取所有建筑 用于数据字典 // 需求958 导出模板需要列表获取建筑 by kongfm 2021-09-15
     * @return
     */
    List<LinkedHashMap<String, Object>> getAllBuilding();
    
	Map<String, String> getBuildingToLongitudeAndLatitude(String instanceId);

    List<Map<String, Long>> getBuildVideoCount();
    
    int  updateFormInstanceByInstanceAndFieldName(String name,String value ,Long instanceId);

    /**
     * 查询子节点
     * @param id
     * @return
     */
    List<String> selectChildListdate(@Param("id")Long id);
}
