package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 气瓶标签信息
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
@TableName("tz_cylinder_tags")
public class CylinderTags {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
    protected Date recDate;

    @TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String recUserId;

    /**
     * 标签ID
     */
	@TableField("tag_id")
    private String tagId;

    /**
     * 产权单位名称
     */
	@TableField("unit_name")
    private String unitName;

    /**
     * 出厂编号
     */
	@TableField("factory_num")
    private String factoryNum;

    /**
     * 气瓶唯一标识码
     */
	@TableField("sequence_code")
    private String sequenceCode;

    /**
     * 二维码编号
     */
	@TableField("qrCode")
    private String qrCode;

    /**
     * 电子标签编号
     */
	@TableField("electronic_label_code")
    private String electronicLabelCode;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 0-新增   1-更新  2-删除
     */
	@TableField("sync_state")
    private Integer syncState;

    /**
     * 对接公司编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

}
