package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 站端信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_station_info")
public class FireStationInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 编号
     */
    @TableField("code")
    private String code;

    /**
     * 换流站类型
     */
    @TableField("elec_type_name")
    private String elecTypeName;

    /**
     * 用途类型
     */
    @TableField("use_type_name")
    private String useTypeName;

    /**
     * 安全指数
     */
    @TableField("safety_index")
    private BigDecimal safetyIndex;

    /**
     * 安全状态：1-重大风险、2-较大风险、3-一般风险、4-低风险
     */
    @TableField("safety_status")
    private Long safetyStatus;

    /**
     * 安全状态描述
     */
    private String safetyStatusName;

    /**
     * 状态对应颜色
     */
    @TableField("safety_status_color")
    private String safetyStatusColor;

    /**
     * 0-启用；1-停用
     */
    @TableField("status")
    private Boolean status;

    /**
     * 位置描述
     */
    @TableField("position")
    private String position;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

    /**
     * 换流站负责人
     */
    @TableField("station_charge_person")
    private String stationChargePerson;

    /**
     * 负责人联系电话
     */
    @TableField("charge_person_phone")
    private String chargePersonPhone;

    /**
     * 安全负责人
     */
    @TableField("safety_charge_person")
    private String safetyChargePerson;

    /**
     * 安全负责人联系电话
     */
    @TableField("safety_person_phone")
    private String safetyPersonPhone;


    /**
     * 驻站消防队队长名称
     */
    @TableField("fire_captain_person")
    private String fireCaptainPerson;

    /**
     * 驻站消防队队长电话
     */
    @TableField("fire_captain_phone")
    private String fireCaptainPhone;
}
