package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanTaskExecution {
	UNFINISHED("尚未开始",0),
	FINISHED("未完成",1),
	OVERTIME("已完成",2),
	NOTSTART("超时漏检  ",3),
	OUTSIDE("计划外完成",4);
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private PlanTaskExecution(String name, int value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(int value) {
		for (PlanTaskExecution c : PlanTaskExecution.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (PlanTaskExecution c : PlanTaskExecution.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static PlanTaskExecution getEnum(int value) {
		for (PlanTaskExecution c : PlanTaskExecution.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskExecution getEnum(String name) {
		for (PlanTaskExecution c : PlanTaskExecution.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PlanTaskExecution c: PlanTaskExecution.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
