package com.yeejoin.equipmanage.common.vo;

import com.yeejoin.equipmanage.common.entity.DynamicFormInstance;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zjw
 * @date 2020-09-04
 */
@Data
@ApiModel(description = "消防系统")
public class FireFightingSystemVo implements Serializable {

    private static final long serialVersionUID = 227556123123599L;
    /**
     * 主键
     */
    private String id;

    /**
     * 名称
     */
    private String name;

    /**
     * 编号
     */
    private String code;

    /**
     * 系统类别
     */
    private String systemType;
    private String systemTypeCode;

    private Long formGroupId;
    /**
     * 安装日期
     */
    private String installDate;

    /**
     * 负责人
     */
    private String chargePerson;
    private String chargePersonPhone;
    private String chargePersonName;


    /**
     * 施工单位
     */
    private String constructionUnit;
    private String constructionUnitCode;
    /**
     * 维保单位
     */
    private String maintenanceUnit;
    private String maintenancePhone;
    private String maintenanceUnitCode;
    /**
     * 维保频率
     */
    private String maintenanceFrequency;

    /**
     * 首次维保日期
     */
    private String firstMaintenanceDate;

    /**
     * 最后更新者的id
     */
    private String recUserId;

    /**
     * 更新时间
     */
    private String  recDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 系统图片url
     */
    private List<FileUploadVo> systemimg;
    /**
     * 平面图
     */
    private List<FileUploadVo> faceimg;
    /**
     * 视频说明
     */
    private  List<FileUploadVo> video;
    /**
     * 操作手册
     */
    private List<FileUploadVo> instruction;
    /**
     * 资质证书
     */
    private  List<FileUploadVo> asser;

    private  List<FileUploadVo> spotimg;

    private  List<FileUploadVo> tdmod;


    /**
     * 排序
     */
    private String sort;

    /**
     * 画布id
     */
    private Long sceneId;

    /**
     * 设备数量
     */
    private Integer equipCount;

    private String orgCode;


    /**
     * 控制柜所在建筑
     */
    private String controBoxBuild;
    /**
     * 保护对象
     */
    private String proObject;
    /**
     * 产品编码
     */
    private String proCode;
    /**
     * 生产厂家
     */
    private String factory;
    /**
     * 控制柜安装位置
     */
    private String controBoxAddress;

    /**
     * 动态表单实例id
     */
    private Long instanceId;

    List<DynamicFormInstance> formInstances;
    
    /**
     * 状态
     */
    private String status;

}
