package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.equipmanage.common.datasync.entity.FireFightingSystem;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.common.vo.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface FireFightingSystemMapper extends BaseMapper<FireFightingSystemEntity> {

    /**
     * 根据系统id查询设备列表
     *
     * @param systemId
     * @return
     */
    List<EquiplistSpecificBySystemVO> getEquiplistBySystemId(Long systemId);

    /**
     * 根据系统id查询分组设备数量
     *
     * @param systemId
     * @return
     */
    List<EquipCountBySystemVO> getEquipCountBySystemId(Long systemId);

    /**
     * 保存
     *
     * @param vo
     * @return
     */
    int save(FireFightingSystemVo vo);

    /**
     * 修改
     *
     * @param vo
     * @return
     */
    int update(FireFightingSystemVo vo);

    /**
     * 保存文件
     *
     * @param vo
     * @return
     */
    int insertFile(FileUploadVo vo);

    /**
     * 删除文件
     *
     * @param id
     * @return
     */
    int deleteFilre(String id);

    /**
     * 系统绑定画布id
     *
     * @param vo
     * @return
     */
    int setSceneId(FireFightingSystemVo vo);

    /**
     * 获取装备数据
     *
     * @return
     */
    List<PointTreeVo> getPointData(@Param("id") String id);

    /**
     * 获取装备数据
     *
     * @return
     */
    List<PointTreeVo> get3dPointData();

    /**
     * 装备点性能指标接口
     *
     * @return
     */
    List<SpeIndexVo> getSpeIndex(Long id);

    /**
     * 按照组态格式获取系统详情
     *
     * @param id
     * @return
     */
    List<AlarmDataVO> getSystemById(Long id);

    IPage<EquipmentAlarmBySystemIdOrSourceIdVO> getEquipmentAlarmBySystemIdOrSourceIdVO(@Param("page")IPage<EquipmentAlarmBySystemIdOrSourceIdVO> page
    		, @Param("sourceId")Long sourceId
    		, @Param("systemId")Long systemId
    		, @Param("confirmType")Integer confirmType
    		, @Param("createDate")String createDate
    		, @Param("type")String type);

    IPage<EquipTypeImgAmountVO> getColaCategoryAmountList(@Param("page")IPage page, 
    		@Param("hierarchy")int hierarchy,
    		@Param("codeHead")String codeHead, 
    		@Param("equipTypeAmountPage")EquipTypeAmountPageDTO equipTypeAmountPage);

    List<FireFightingSystem> getFireFightingSystemDetail(@Param("fireFightingSystemVo")FireFightingSystemVo fireFightingSystemVo);

    List<FireFightingSystemEntity> getFightingSysByCodes(@Param("ids") String[] idsArr);

    List<FireFightingSystemEntity> getFightingSysByIds(@Param("ids") String[] idsArr);

    List<FireFightingSystem3dVo> get3dFightingSystemList(@Param("list") List<String> collect);

    List<SpeIndexVo> getSpeIndexIn(@Param("list") List<Long> idList);
    

 
    Map<String, Object> getFireSystemState();
    
    Map<String, Object> getFireOnlSystem();
    
    Map<String, Object> getFireOnlSystemThreeSmall();

    Map<String, Object> getFireCafsSystem();

    Map<String, Object> getFireFfsSystem();

    Map<String, Object> getFireFasSystem();

    Map<String, Object> getFireAcsSystem();

    Map<String, Object> getFireFhsSystem();
    
    Map<String, Object> getTodayConfirmAlarmInfo();

    Map<String, Object> getPoolInfo();
    
    FireFightingSystemVo getFightingSysInfo(@Param("code") String code, @Param("id") Long id);

    /**
     * 火灾报警系统3小 ，装备定义数量
     * @return Map<String,Object>
     */
    Map<String,Object>  fireAlarmSysEquipmentNumber();

    /**
     * 火灾报警系统3小,指标
     * @return Map<String,Object>
     */
    Map<String,Object> fireAlarmSysIndexNumber();

    /**
     *  消防水系统-》12号消防水池
     * @return  Map<String,Object>
     */
    Map<String,Object> fireWaterSysPool();

    /**
     *  消防水系统-》消防管网
     * @return  Map<String,Object>
     */
    Map<String,Object> fireWaterSysPipeNetwork();


    /**
     * 消防水系统-》消火栓按钮
     * @return Map<String,Object>
     */
    Map<String,Object> fireWaterSysHydrant();

    /**
     * 消防水系统-》水泵房采集装置
     * @return Map<String,Object>
     */
    Map<String,Object> fireWaterSysCollectingDevice();

    /**
     * 消防水系统-》消防泵、稳压泵,大屏用
     * @return Map<String,Object>
     */
    Map<String,Object> fireWaterSysWaterPump();

    /**
     * 预混泡沫灭火系统3小
     * @return Map<String,Object>
     */
    Map<String,Object> fireFoamSysEquipmentIndexNumber();

    /**
     * 其他系统总数及指标数量
     * @return Map<String,Object>
     */
    Map<String,Object> otherSysIndexNumAndTotal();

    /**
     * 预混泡沫灭火系统概览
     * @return Map<String,Object>
     *
     */
    Map<String,Object> fireFoamSysEquipmentNumber();

}
