package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertFormDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertFormInitDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertListvalue;
import com.yeejoin.amos.boot.module.elevator.api.dto.Items;
import com.yeejoin.amos.boot.module.elevator.api.entity.AlertForm;
import com.yeejoin.amos.boot.module.elevator.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.elevator.api.mapper.AlertFormMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IAlertFormService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 警情表单 服务实现类
 *
 * @author tb
 * @date 2021-06-17
 */
@Service
public class AlertFormServiceImpl extends BaseService<AlertFormDto, AlertForm, AlertFormMapper>
		implements IAlertFormService {
	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;

	public List<AlertFormInitDto> getFormlist(String code) {

		QueryWrapper<AlertForm> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("alert_type_code", code);
		queryWrapper.orderByAsc("sort_num");
		List<AlertForm> alertFormValue = this.list(queryWrapper);
		List<AlertFormInitDto> listfrom = new ArrayList<AlertFormInitDto>();
		// 组装数据
		for (AlertForm alertFrom : alertFormValue) {
			if (alertFrom.getFieldType().equals("string") || alertFrom.getFieldType().equals("datetime")
					|| alertFrom.getFieldType().equals("textarea") || alertFrom.getFieldType().equals("inputBitmap")
					|| alertFrom.getFieldType().equals("input")) {

				AlertFormInitDto vo = new AlertFormInitDto(alertFrom.getFieldCode(), alertFrom.getFieldName(),
						alertFrom.getFieldType(), null, alertFrom.getUrl());
				AlertFormValue alertFormValu = new AlertFormValue(alertFrom.getSequenceNbr(), alertFrom.getFieldName(),
						alertFrom.getFieldCode(), alertFrom.getBlock(), alertFrom.getAlertTypeCode(), null, null);

				if (alertFrom.getFieldType().equals("datetime")) {
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					Date date = new Date();
					String dateString = formatter.format(date);
					alertFormValu.setFieldValue(dateString);
					vo.setDefaultValue(date);
				}
				vo.setFormItemDescr(alertFormValu);
				listfrom.add(vo);
			} else {
				// 查询数据项
				QueryWrapper<DataDictionary> queryWrappercolumnMap = new QueryWrapper<>();
				queryWrappercolumnMap.eq("type", alertFrom.getFieldValueCode());
				queryWrappercolumnMap.orderByAsc("sort_num");
				Collection<DataDictionary> listDataDictionary = iDataDictionaryService.list(queryWrappercolumnMap);
				List<AlertListvalue> list = getdata(listDataDictionary);
				AlertFormInitDto vo = new AlertFormInitDto(alertFrom.getFieldCode(), alertFrom.getFieldName(),
						alertFrom.getFieldType(), new Items(list), alertFrom.getUrl());
				AlertFormValue alertFormValu = new AlertFormValue(alertFrom.getSequenceNbr(), alertFrom.getFieldName(),
						alertFrom.getFieldCode(), alertFrom.getBlock(), alertFrom.getAlertTypeCode(), null, null);
				if (alertFrom.getFieldType().equals("radio")) {
					vo.setDefaultValue(list.get(0).getValue());
					alertFormValu.setFieldValue(list.get(0).getLabel());
					alertFormValu.setFieldValueCode(list.get(0).getValue());
				}

				vo.setFormItemDescr(alertFormValu);
				listfrom.add(vo);
			}
		}
		return listfrom;
	}

	public List<AlertListvalue> getdata(Collection<DataDictionary> list) {
		List<AlertListvalue> listAlertListvalue = new ArrayList<AlertListvalue>();
		for (DataDictionary dataDictionary : list) {

			listAlertListvalue.add(new AlertListvalue(dataDictionary.getSequenceNbr().toString(),
					dataDictionary.getName(), dataDictionary.getCode()));
		}
		return listAlertListvalue;
	}

	public List<String> queryListByFormId(String groupId) {
		return this.queryListByTypeCode(groupId).stream().map(c -> c.getFieldCode()).collect(Collectors.toList());
	}

	public List<AlertFormDto> queryListByTypeCode(String groupId) {
		return this.queryForList(null, false, groupId);
	}
}
