package com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderFilling;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderFillingCheck;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderFillingRecord;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderInfo;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylCylinderFillingCheckMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;

/**
 * 液化气体气瓶同步实现类
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Service
@DS("openapi")
public class CylinderSyncServiceImpl {
	@Autowired
	private CylCylinderFillingCheckMapper fillingCheckMapper;

	public Integer getFillCheckListTotal() {
		return fillingCheckMapper.getFillingCheckListTotal();
	}

	public List<CylinderFillingCheck> getFillingCheckList() {
		return fillingCheckMapper.getFillingCheckList();
	}

	public void updateBatch(HashSet<String> appIdList, HashSet<String> fillingCheckIdList) {
		fillingCheckMapper.updateFillingCheckBatch(appIdList, fillingCheckIdList);
	}



	public Integer getCylinderInfoCount() {
		return fillingCheckMapper.getCylinderInfoCount();
	}

	public List<CylinderInfo> getCylinderInfoList() {
		return fillingCheckMapper.getCylinderInfoList();
	}

	public void updateBatch(List<Long> sequenceNbrS) {
		fillingCheckMapper.updateBatch(sequenceNbrS);
	}

	public List<CylinderFilling> queryUnSyncFilling() {
		return fillingCheckMapper.queryUnSyncFilling();
	}

	public boolean updataSyncFilling(List<Long> ids){
		return fillingCheckMapper.updataSyncFilling(ids);
	}

	public Long fillingRecordSync(){
		return fillingCheckMapper.selectCountTotal();
	}

	public List<CylinderFillingRecord> fillingRecordSyncRecords(){
		return fillingCheckMapper.fillingRecordSyncRecords();
	}

	public void updateSyncState(List<Long> ids){
		fillingCheckMapper.updateSyncState(ids);
	}
}