package com.yeejoin.amos.boot.module.jg.api.dto;

import lombok.Data;

import java.util.Objects;

/**
 * @author Administrator
 */
@Data
public class JgBizCountDataDto {

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JgBizCountDataDto that = (JgBizCountDataDto) o;
        return receiveCompanyCode.equals(that.receiveCompanyCode) &&
                bizType.equals(that.bizType) &&
                equList.equals(that.equList) &&
                equCategory.equals(that.equCategory) &&
                Objects.equals(equDefine, that.equDefine);
    }

    @Override
    public int hashCode() {
        return Objects.hash(receiveCompanyCode, bizType, equList, equCategory, equDefine);
    }

    /**
     * 接收机构公司编码
     */
    private String receiveCompanyCode;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 设备种类
     */
    private String equList;


    /**
     * 设备类别
     */
    private String equCategory;


    /**
     * 设备品种
     */
    private String equDefine;
}
